# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components.configs.matrix import _constants as matrix_constants

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class MatrixCfg(configs.ReferenceCIConfig):
    name = "matrix"
    display_name = "Alice.Matrix (notificator)"
    responsible = matrix_constants.RESPONSIBLE

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "alice/matrix/notificator"
        secret = matrix_constants.CI_SECRET
        sb_owner_group = matrix_constants.SB_OWNER_GROUP

        ya_make_abs_paths_glob = matrix_constants.DEFAULT_YA_MAKE_ABS_PATHS_GLOB + [
            "alice/matrix/notificator/**",
        ]

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/matrix/build_matrix"

        def _get_build_cube(self, graph):
            build = build_cubes.YaMakeTemplate(
                # Hack to avoid target_resources override
                target_resources=None,
                name="build",
                task=self.build_task,
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )
            build.input.update(thinlto=True)
            return build

    class Releases(configs.ReferenceCIConfig.Releases):
        release_followers_permanent = matrix_constants.DEFAULT_FOLLOWERS
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.nanny_push

        @property
        def releasable_items(self):
            production_deploy_infos = [
                ri.NannyPushDeployInfo(
                    [
                        ri.DeployService("matrix-{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                    ] + [
                        ri.DeployService("matrix-prestable"),
                    ],
                    stage=rm_const.ReleaseStatus.stable,
                ),
            ]
            testing_deploy_infos = [
                ri.NannyPushDeployInfo(
                    [
                        ri.DeployService("matrix-test"),
                    ],
                    stage=rm_const.ReleaseStatus.testing,
                ),
            ]
            dev_deploy_infos = [
                ri.NannyPushDeployInfo(
                    [
                        ri.DeployService("matrix-dev"),
                    ],
                    stage=rm_const.ReleaseStatus.testing,
                ),
            ]
            all_deploy_infos = production_deploy_infos + testing_deploy_infos + dev_deploy_infos
            return [
                # All
                ri.ReleasableItem(
                    name="matrix_binary",
                    data=ri.SandboxResourceData("MATRIX_BINARY", dst_path="matrix"),
                    deploy_infos=all_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="matrix_instancectl_config",
                    data=ri.SandboxResourceData("MATRIX_INSTANCECTL_CONFIG", dst_path="instancectl.conf"),
                    deploy_infos=all_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="matrix_logrotate_config",
                    data=ri.SandboxResourceData("MATRIX_LOGROTATE_CONFIG", dst_path="logrotate.conf"),
                    deploy_infos=all_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="matrix_push_client_config",
                    data=ri.SandboxResourceData("MATRIX_PUSH_CLIENT_CONFIG", dst_path="push_client_config.yaml"),
                    deploy_infos=all_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="matrix_tvmtool_config",
                    data=ri.SandboxResourceData("MATRIX_TVM_TOOL_CONFIG", dst_path="tvmtool_config.json"),
                    deploy_infos=all_deploy_infos,
                ),

                ri.ReleasableItem(
                    name="matrix_config_production",
                    data=ri.SandboxResourceData("MATRIX_CONFIG_PRODUCTION", dst_path="config.json"),
                    deploy_infos=production_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="matrix_config_testing",
                    data=ri.SandboxResourceData("MATRIX_CONFIG_TESTING", dst_path="config.json"),
                    deploy_infos=testing_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="matrix_config_dev",
                    data=ri.SandboxResourceData("MATRIX_CONFIG_DEV", dst_path="config.json"),
                    deploy_infos=dev_deploy_infos,
                ),
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = matrix_constants.DEFAULT_ASSIGNEE
            queue = matrix_constants.RELEASES_QUEUE
            dev_queue = matrix_constants.DEV_QUEUE
            summary_template = u"Приемка matrix {}"
            workflow = {}
            followers = matrix_constants.DEFAULT_FOLLOWERS
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "matrix/notificator/releases/"
        observed_paths = matrix_constants.DEFAULT_OBSERVED_PATHS + [
            "arcadia/alice/matrix/notificator",
        ]

        use_previous_branch_as_baseline = True

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        # moved to the CI since the 41th branch
        # moved to other CI project since the 54th branch
        start_version = 55
