# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.common.constants import constants as common_const

import sandbox.projects.mediabilling.rm as rm_conf
import sandbox.projects.release_machine.core.const as rm_const


def ya_make_test_params(paths, timeout=5 * 60 * 60):
    return {
        common_const.BUILD_SYSTEM_KEY: common_const.DISTBUILD_BUILD_SYSTEM,
        common_const.BUILD_TYPE_KEY: common_const.RELEASE_WITH_DEBUG_INFO_BUILD_TYPE,
        common_const.USE_AAPI_FUSE: True,
        common_const.DOWNLOAD_ARTIFACTS_FROM_DISTBUILD: True,
        common_const.REPORT_TESTS_ONLY: True,
        common_const.CHECK_RETURN_CODE: True,  # Report about any infrastructure error directly.
        common_const.FAILED_TESTS_CAUSE_ERROR: False,  # Report about failed tests indirectly via results.json.
        common_const.TEST_SIZE_FILTER: "small,medium",
        common_const.YA_TIMEOUT: timeout,
        "cache_test_results": False,
        "test": True,
        "test_retries": 1,
        "targets": ";".join(paths),
        "ram_drive_size": 4 * 1024,
    }


class MediabillingBase(cfg.ReferenceCIConfig):

    name = ""
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=2411, role_id=None, schedule_slug="mbduty"), login="ababkin")
    component_group = rm_conf.COMPONENT_GROUP

    class CI(cfg.ReferenceCIConfig.CI):

        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = rm_conf.TRUNK_TASK_OWNER
        a_yaml_dir = ""
        ya_make_abs_paths_glob=[]

    class JG(basic_build_presets.SingleBuildGeneralJGCfg):

        ya_make_test_paths = []

        @jg_flow.release_flow(stages=basic_build_presets.DEFAULT_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(MediabillingBase.JG, self).release(self)
            main_entry = graph.get(dummy_cubes.RMMainGraphEntry.NAME)
            release_entry = graph.get("release_stage_entry")

            test_cube = jg_cube.Cube(
                name="run_tests",
                title="RunTests",
                needs=[main_entry],
                task="common/arcadia/ya_make",
                input=cube_base.CubeInput(**ya_make_test_params(self.ya_make_test_paths)),
            )
            release_entry.add_requirement(test_cube)
            graph.add(test_cube)

            return graph

        @property
        def release_task(self):
            return build_cubes.AfishaBuildDocker.DEFAULT_TASK

        @property
        def build_task(self):
            return release_cubes.AfishaRelease2.TASK

        def _get_build_cube(self, graph):
            return build_cubes.AfishaBuildDocker(
                component_name=self.component_name,
                package_path=self.root_cfg.releases_cfg.releasable_items[0].build_data.target,
                needs=[graph.get("main_graph_entry"), graph.get(internal_cubes.CreateStartrekTicket.NAME)],
                input=jg_cube.CubeInput(
                    arc_svn_url="${tasks.new_tag.svn_data.svn_paths.tag}/arcadia",
                    checkout_arcadia_from_url="${tasks.new_tag.svn_data.svn_paths.tag}/arcadia",
                ),
            )

        def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
            return [
                release_cubes.AfishaRelease2(
                    name="release_{}_{}".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    manual=(True if where == "stable" else False),
                )
            ]

    class Notify(cfg.ReferenceCIConfig.Notify):
        """ Notification settings """

        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications
            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            summary_template = ""
            assignee = cfg.Responsible(
                abc=cfg.Abc(component_id=2411, role_id=None, schedule_slug="mbduty"), login="ababkin"
            )
            queue = rm_conf.STARTREK_QUEUE
            followers = rm_conf.STARTREK_FOLLOWERS
            add_commiters_as_followers = True
            abc_followers = cfg.Abc(role_id=16, component_id=2411)
            ticket_type = u"Релиз"
            use_task_author_as_assignee = False
            hide_commits_under_cut = True
            nanny_reports = False
            deadline = 7
            important_changes_limit = rm_conf.IMPORTANT_CHANGES_LIMIT

            @property
            def tags(self):
                return ["rm_main_ticket", self.name, "component_name_{}".format(self.name)]

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """
        dirs = []
        wiki_page = ""

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):

        branch_name = ""
        tag_name = ""
        start_version = 0
        use_arc = True
        tag_folder_template = "{branch_num}.{tag_num}"
        allow_autobranches = True

    class Releases(cfg.ReferenceCIConfig.Releases):
        """Releases configuration"""

        package_json_path = ""
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.sandbox

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=rm_conf.RELEASE_RESOURCE,
                    data=ri.SandboxResourceData(rm_conf.RELEASE_RESOURCE, build_ctx_key="arc_svn_url",
                                                attributes={"component_name": self.name}),
                    build_data=ri.BuildData(
                        target=self.package_json_path,
                    ),
                    deploy_infos=[
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
            ]
