# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.media_billing import _mediabilling_base as base


class MediabillingCommonAdmin(base.MediabillingBase):
    name = "mediabilling_common_admin"  # module name

    class CI(base.MediabillingBase.CI):
        a_yaml_dir = "media-billing/common-admin"  # path to a.yaml directory
        ya_make_abs_paths_glob = [
            "media-billing/common-admin/**",
        ]

    class JG(base.MediabillingBase.JG):
        ya_make_test_paths = ["media-billing/common-admin"]  # path to ya.make directory for tests

    class Notify(base.MediabillingBase.Notify):

        class Startrek(base.MediabillingBase.Notify.Startrek):
            summary_template = "Common Admin {}"

    class ChangelogCfg(base.MediabillingBase.ChangelogCfg):
        dirs = [
            "media-billing/common-admin"  # directories for changelog
        ]
        wiki_page = ""

    class SvnCfg(base.MediabillingBase.SvnCfg):
        branch_name = "media-billing/common-admin"
        tag_name = "media-billing/common-admin"
        start_version = 2

    class Releases(base.MediabillingBase.Releases):
        package_json_path = "media-billing/common-admin/docker/package.json"
