# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.media_billing import _mediabilling_base as base


class MediabillingGraphqlAdmin(base.MediabillingBase):
    name = "mediabilling_graphql_admin"  # module name

    class CI(base.MediabillingBase.CI):
        a_yaml_dir = "media-billing/graphql-admin"  # path to a.yaml directory
        ya_make_abs_paths_glob = [
            "media-billing/graphql-admin/**",
        ]

    class JG(base.MediabillingBase.JG):
        ya_make_test_paths = ["media-billing/graphql-admin"]  # path to ya.make directory for tests

    class Notify(base.MediabillingBase.Notify):

        class Startrek(base.MediabillingBase.Notify.Startrek):
            summary_template = "Graphql Admin {}"

    class ChangelogCfg(base.MediabillingBase.ChangelogCfg):
        dirs = [
            "media-billing/graphql-admin"  # directories for changelog
        ]
        wiki_page = ""

    class SvnCfg(base.MediabillingBase.SvnCfg):
        branch_name = "media-billing/graphql-admin"
        tag_name = "media-billing/graphql-admin"
        start_version = 131

    class Releases(base.MediabillingBase.Releases):
        package_json_path = "media-billing/graphql-admin/docker/package.json"
