# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components.configs.media_billing import _mediabilling_base as base
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.common.constants import constants as common_const

import sandbox.projects.mediabilling.rm as rm_conf
import sandbox.projects.release_machine.core.const as rm_const


def ya_make_test_params(paths, timeout=2 * 60 * 60):
    return {
        common_const.BUILD_SYSTEM_KEY: common_const.DISTBUILD_BUILD_SYSTEM,
        common_const.BUILD_TYPE_KEY: common_const.RELEASE_WITH_DEBUG_INFO_BUILD_TYPE,
        common_const.USE_AAPI_FUSE: True,
        common_const.DOWNLOAD_ARTIFACTS_FROM_DISTBUILD: True,
        common_const.REPORT_TESTS_ONLY: True,
        common_const.CHECK_RETURN_CODE: True,  # Report about any infrastructure error directly.
        common_const.FAILED_TESTS_CAUSE_ERROR: False,  # Report about failed tests indirectly via results.json.
        common_const.TEST_SIZE_FILTER: "small,medium",
        common_const.YA_TIMEOUT: timeout,
        "cache_test_results": False,
        "test": True,
        "test_retries": 1,
        "targets": ";".join(paths),
        "ram_drive_size": 4 * 1024,
    }


class MediabillingGraphqlGateway(base.MediabillingBase):
    name = "mediabilling_graphql_gateway"  # module name

    class CI(base.MediabillingBase.CI):
        a_yaml_dir = "media-billing/graphql-gateway"  # path to a.yaml directory
        ya_make_abs_paths_glob = [
            "media-billing/graphql-gateway/**",
        ]

    class JG(base.MediabillingBase.JG):
        ya_make_test_paths = ["media-billing/graphql-gateway"]  # path to ya.make directory for tests

        @jg_flow.release_flow(stages=basic_build_presets.DEFAULT_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(base.MediabillingBase.JG, self).release(self)
            main_entry = graph.get(dummy_cubes.RMMainGraphEntry.NAME)
            release_entry = graph.get("release_stage_entry")

            test_cube = jg_cube.Cube(
                name="run_tests",
                title="RunTests",
                needs=[main_entry],
                task="common/arcadia/ya_make",
                input=cube_base.CubeInput(**ya_make_test_params(self.ya_make_test_paths)),
            )
            release_entry.add_requirement(test_cube)
            release_stable = graph.get("release_stable_sandbox")
            release_prestable = graph.get("release_prestable_sandbox")
            release_testing = graph.get("release_testing_sandbox")

            release_testing.add_requirement(release_entry)
            release_prestable.add_requirement(release_testing)
            release_stable.add_requirement(release_prestable)
            graph.add(test_cube)

            return graph

        def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
            return [
                release_cubes.AfishaRelease2(
                    name="release_{}_{}".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    manual=(True if where in ["stable", "prestable"] else False),
                )
            ]

    class Notify(base.MediabillingBase.Notify):

        class Startrek(base.MediabillingBase.Notify.Startrek):
            summary_template = "Graphql Gateway {}"

    class ChangelogCfg(base.MediabillingBase.ChangelogCfg):
        dirs = [
            "media-billing/graphql-gateway"  # directories for changelog
        ]
        wiki_page = ""

    class SvnCfg(base.MediabillingBase.SvnCfg):
        branch_name = "media-billing/graphql-gateway"
        tag_name = "media-billing/graphql-gateway"
        start_version = 1

    class Releases(base.MediabillingBase.Releases):
        package_json_path = "media-billing/bootstrap/docker/graphql-gateway/package.json"

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=rm_conf.RELEASE_RESOURCE,
                    data=ri.SandboxResourceData(rm_conf.RELEASE_RESOURCE, build_ctx_key="arc_svn_url",
                                                attributes={"component_name": self.name}),
                    build_data=ri.BuildData(
                        target=self.package_json_path,
                    ),
                    deploy_infos=[
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.prestable),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
            ]
