# -*- coding: utf-8 -*-
import re

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class ReleaseMachineTestCfg(configs.ReferenceBranchedConfig):
    name = rm_const.RMNames.MEDIA_STORIES
    display_name = "Media Stories"
    responsible = configs.Responsible(login="krabishe")

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        observed_paths = [
            "arcadia/media-stories"
        ]
        wiki_page = ""

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 5 * 60
        deploy_system = rm_const.DeploySystem.ya_deploy

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="media_stories_binary",
                    data=ri.SandboxResourceData(
                        "MEDIA_STORIES_BINARY",
                        docker_image_data_re=re.compile(
                            r"stable-(?P<major>\d+)-(?P<minor>\d+)\.(?P<revision>\d+)\.(?P<task_id>\d+)"
                        )
                    ),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("media-stories-production")),
                        ri.YaDeployInfo(
                            ri.DeployService("media-stories-testing"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ]
                ),
            ]

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "media-stories-trunk"
        trunk_task_owner = "MEDIA-STORIES"
        branch_db_template = "media-stories-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):

            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(use_arc=self._use_arc)
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(jg_build.JobGraphElementYaMakeBuildBranched(
                    task_name="YA_PACKAGE",
                    out={"MEDIA_STORIES_BINARY": 5},
                    ctx={
                        "packages": "media-stories/ya-package.json",
                        "package_type": "docker",
                        "resource_type": "MEDIA_STORIES_BINARY",

                        "docker_registry": "registry.yandex.net",
                        "docker_user": "robot-media-stories",
                        "docker_token_vault_name": "robot-media-stories.docker-token",
                        "docker_push_image": True,
                        "docker_build_network": "host",

                        "release_to_ya_deploy": True,
                        "yp_token_vault": "robot-media-stories.yandexdeploy-token",

                        "ya_yt_store": False,
                        "use_aapi_fuse": True,
                        "ignore_recurses": True,
                    },
                ))
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        release_to=release_stage,
                    ))
                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=release_stage,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.sandbox.name,
                            }
                        },
                        job_arrows=[
                            jg_triggers.JobTriggerBuild(
                                parent_job_data=[
                                    jg_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="media_stories_binary",
                                        resource_name="MEDIA_STORIES_BINARY",
                                    ),
                                ],
                            ),
                            jg_triggers.JobTriggerNewTag([
                                jg_data.ParentDataOutput('major_release_num', 'branch_number_for_tag'),
                                jg_data.ParentDataOutput('minor_release_num', 'new_tag_number'),
                            ]),
                        ]
                    ))
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):

            @property
            def change_frequency(self):
                return {}

            @property
            def ignore_match(self):
                return super(ReleaseMachineTestCfg.Testenv.JobPatch, self).ignore_match

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = "STORIESRELEASES"
            assignee = "krabishe"
            followers = [
                "krabishe"
            ]
            ticket_type = "Release"
            summary_template = "Media Stories release {}"
            add_commiters_as_followers = False

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        use_arc = True
        arc_tag_folder = "tags/releases"
        arc_branches_folder = "releases"
        branch_name = "media-stories"
        tag_name = "media-stories"
