# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs


class MediabillingCfg(configs.ReferenceBranchedConfig):
    name = "mediabilling"
    responsible = "svoropaev"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "MEDIABILLING"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = []

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mediabilling/common"
        tag_name = "mediabilling/common"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["Mediabilling.Status"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "svoropaev"
            queue = "MBRM"
            dev_queue = "MBRMDEV"
            summary_template = u"Релиз Медиабиллинга {}"
            workflow = {}
            followers = [
                "svoropaev",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "mb/rmreleases/"
        wiki_page_owner = "robot-mediabilling"
        dirs = [
            "arcadia/media-billing"
        ]
        review_groups = [
            "mediabilling",
        ]
