# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri


class MementoCfg(configs.ReferenceCIConfig):
    name = "memento"
    display_name = "Alisa Memento"
    responsible = configs.Responsible(
        abc=configs.Abc(
            service_name="yandexdialogs2",
            component_id=1886,
        ),
        login="pazus",
    )
    robot = "robot-paskills-ci"

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "alice/memento"
        secret = "sec-01crfgwyybj70jjrgcj1jfkehn"
        sb_owner_group = "PASKILLS"
        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):

            _preset = ci_presets.SingleBuildPackageCiPreset(
                resource_names="MEMENTO_BINARY",
                package_names="alice/memento/pkg.json",
                build_task_name="YA_PACKAGE_2",
                build_apiargs={
                    "kill_timeout": 2700,
                },
                build_ctx={
                    "build_system": "semi_distbuild",
                    "packages": "alice/memento/pkg.json",
                    "resource_type": "MEMENTO_BINARY",
                    "use_new_format": True,
                    "package_type": "docker",
                    "build_type": "release",
                    "docker_push_image": True,
                    "docker_registry": "registry.yandex.net",
                    "docker_image_repository": "paskills",
                    "docker_user": "robot-paskills-ci",
                    "docker_token_vault_name": "robot-paskills-ci-docker-registry-token",
                    "docker_build_network": "host",
                    "checkout": False,
                    "ya_yt_store": True,
                    "ignore_recurses": False,
                    "custom_version": "release-r${context.target_revision.number}-"
                                      "${context.version_info.major}.${not_null(context.version_info.minor, `0`)}",

                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing, jg_utils.Lazy()),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable, jg_utils.Lazy()),
                ],
            )

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["dialogovo-releases"]

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            assignee = "osennikovak"
            queue = "ALICERELEASE"
            dev_queue = "PASKILLS"
            summary_template = u"Релиз Alice Memento {}"

            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                assignee,
                "kuptservol"
                "pazus",
                "ivangromov",
                "svintenok",
                "pazus"
            ]
            add_commiters_as_followers = True
            hide_commits_under_cut = True

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        use_arc = True
        arc_tag_folder = "tags/releases/alice"
        arc_branches_folder = "releases/alice"
        start_version = 7  # moved to The CI since the 6th branch

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        observed_paths = ["arcadia/alice/memento"]
        wiki_page = ""

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="MEMENTO_BINARY",
                    data=ri.SandboxResourceData("MEMENTO_BINARY", ttl=20),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            ri.DeployService("memento-{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                        ),
                        ri.NannyDeployInfo(
                            [ri.DeployService("memento-priemka")],
                            stage=rm_const.ReleaseStatus.testing,
                        ),
                    ]
                )
            ]

        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 10 * 60  # 10 min
