# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import metrics as metrics_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow


METRICS_TEMPLATE_RESOURCE_TYPE = "METRICS_TEMPLATE_RESOURCE"


class MetricsTemplatesCfg(configs.ReferenceCIConfig):

    name = "metrics_templates"
    description = "MLM templates for LaunchMetrics"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="ups"),
        login="ilyaturuntaev",
    )

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):

        def get_launch_metrics_testing_cube(self, custom_template_name, build):

            return metrics_cubes.LaunchMetrics(
                name="launch_metrics__{}".format(custom_template_name.replace(".", "_")),
                title="Test LaunchMetrics {}".format(custom_template_name),
                component_name=self.component_name,
                search_subtype="web",
                input=jg_cube.CubeInput(
                    run_findurl=False,
                    template_source="resource",
                    template_resource=build.output.resources[METRICS_TEMPLATE_RESOURCE_TYPE].first().id,
                    sample_beta="hamster",
                    checked_beta="hamster",
                    custom_template_name=custom_template_name,
                    launch_template_quota="web-ranking-runtime",
                    enable_autoclicker=True,
                    scraper_over_yt_pool="experiments_rm",
                ),
            )

        @jg_flow.release_flow(
            auto=True,
            title="Release Metrics Templates",
            stages=[
                basic_build_presets.DEFAULT_STAGE_NEW_TAG,
                basic_build_presets.DEFAULT_STAGE_BUILD,
                jg_flow.ReleaseActionStageData(
                    "test",
                    cube_names=[
                        "launch_metrics__common_json",
                        "launch_metrics__experiments_json",
                        "test_stage_entry",
                    ],
                ),
                basic_build_presets.DEFAULT_STAGE_RELEASE,
            ],
        )
        def release(self):
            graph = super(MetricsTemplatesCfg.JG, self).release(self)

            build = graph.get("build")
            release_stage_entry = graph.get("release_stage_entry")
            stable_release = graph.get("release_stable_kosher_sandbox_release")

            build.input.update(
                result_rt=METRICS_TEMPLATE_RESOURCE_TYPE,
                result_rd="Metrics Templates",
                result_resources_types="",  # YaMake2 fails to build resources from sources when this is not empty
            )

            lm_common = self.get_launch_metrics_testing_cube("common.json", build)
            lm_experiments = self.get_launch_metrics_testing_cube("experiments.json", build)

            test_stage_entry = dummy_cubes.Dummy("test_stage_entry")

            for release_stage_requirement in release_stage_entry.requirements:
                test_stage_entry.add_requirement(release_stage_requirement)

            lm_common.add_requirement(test_stage_entry)
            lm_experiments.add_requirement(test_stage_entry)

            release_stage_entry.add_requirement(lm_common)
            release_stage_entry.add_requirement(lm_experiments)

            stable_release.manual = False

            graph.add(test_stage_entry)
            graph.add(lm_common)
            graph.add(lm_experiments)

            return graph

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "search/metrics_templates"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        observed_paths = ["arcadia/search/metrics_templates"]
        wiki_page = ""

    class Releases(configs.ReferenceCIConfig.Releases):

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="metrics_templates",
                    data=ri.SandboxResourceData(METRICS_TEMPLATE_RESOURCE_TYPE, ttl=20),
                    build_data=ri.BuildData(
                        target="search/metrics_templates",
                        artifact="search/metrics_templates=search/",
                        is_source=True,
                    ),
                    deploy_infos=[
                        ri.SandboxKosherReleaseInfo(stage=rm_const.ReleaseStatus.stable),
                    ],
                )
            ]

        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 10 * 60  # 10 min
