# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class MirrorsCfg(configs.ReferenceBranchedConfig):
    name = "mirrors"
    responsible = "bvshuryg"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "JUPITER"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            BINARY_PACKAGES = ['cmpy', 'fetcher', 'hyps', 'merge', 'scheduler', 'tools', 'viewer', 'wrapper']
            TARGETS_WITH_BINARIES_SUFFIX = ['merge', 'hyps', 'tools', 'viewer', 'wrapper']
            CONFIG_PACKAGES = ['cm', 'db', 'fetcher', 'rthub', 'scheduler', 'viewer', 'wrapper']

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                for target in self.BINARY_PACKAGES:
                    job_name_suffix = target.upper() if target not in self.TARGETS_WITH_BINARIES_SUFFIX else '{}_BINARIES'.format(target.upper())
                    resource_type = "MIRRORS_{}".format(job_name_suffix.upper())
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="JUPITER_YA_MAKE",
                            job_params={
                                "apiargs": {
                                    "requirements": {
                                        "disk_space": 50 << 30,  # 50 Gb
                                    },
                                },
                                "job_name_parameter": job_name_suffix,
                            },
                            ctx={
                                "targets": "robot/mirror/packages/binaries/{}".format(target),
                                "arts": "robot/mirror/packages/binaries/{}".format(target),
                                "arts_source": "",
                                "result_rt": resource_type,
                                "result_rd": "Mirrors {}".format(target),
                                "result_single_file": True,
                                sandbox_constants.DEFINITION_FLAGS_KEY: "-DDEBUGINFO_LINES_ONLY=yes",
                                sandbox_constants.CHECKOUT_MODE: sandbox_constants.CHECKOUT_MODE_AUTO,
                                sandbox_constants.CHECKOUT: True,
                                sandbox_constants.CLEAR_BUILD_KEY: False,
                                sandbox_constants.CHECK_RETURN_CODE: True,
                                sandbox_constants.TESTS_REQUESTED: False,
                                sandbox_constants.YA_YT_DIR: "//home/jupiter/yamake_cache",
                                sandbox_constants.YA_YT_PROXY: "arnold.yt.yandex.net",
                                sandbox_constants.YA_YT_PUT: True,
                                sandbox_constants.YA_YT_STORE: True,
                                sandbox_constants.YA_YT_TOKEN_VAULT_NAME: "jupiter_yt_token",
                                sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: "JUPITER",
                            },
                            out={resource_type: 30},
                        )
                    )
                for target in self.CONFIG_PACKAGES:
                    job_name_suffix = '{}_CONFIGS'.format(target.upper())
                    resource_type = "MIRRORS_{}".format(job_name_suffix.upper())
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="JUPITER_YA_MAKE",
                            job_params={
                                "apiargs": {
                                    "requirements": {
                                        "disk_space": 50 << 30,  # 50 Gb
                                    },
                                },
                                "job_name_parameter": job_name_suffix,
                            },
                            ctx={
                                "targets": "robot/mirror/packages/configs/{}".format(target),
                                "arts": "robot/mirror/packages/configs/{}".format(target),
                                "arts_source": "",
                                "result_rt": resource_type,
                                "result_rd": "Mirrors {}".format(target),
                                "result_single_file": True,
                                sandbox_constants.DEFINITION_FLAGS_KEY: "-DDEBUGINFO_LINES_ONLY=yes",
                                sandbox_constants.CHECKOUT_MODE: sandbox_constants.CHECKOUT_MODE_AUTO,
                                sandbox_constants.CHECKOUT: True,
                                sandbox_constants.CLEAR_BUILD_KEY: False,
                                sandbox_constants.CHECK_RETURN_CODE: True,
                                sandbox_constants.TESTS_REQUESTED: False,
                                sandbox_constants.YA_YT_DIR: "//home/jupiter/yamake_cache",
                                sandbox_constants.YA_YT_PROXY: "arnold.yt.yandex.net",
                                sandbox_constants.YA_YT_PUT: True,
                                sandbox_constants.YA_YT_STORE: True,
                                sandbox_constants.YA_YT_TOKEN_VAULT_NAME: "jupiter_yt_token",
                                sandbox_constants.YA_YT_TOKEN_VAULT_OWNER: "JUPITER",
                            },
                            out={resource_type: 30},
                        )
                    )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_job_arrows = []
                for target in self.BINARY_PACKAGES:
                    if target in self.TARGETS_WITH_BINARIES_SUFFIX:
                        job_suffix = '{}_BINARIES'.format(target.upper())
                        resource_type = 'mirrors_{}_binaries'.format(target)
                    else:
                        job_suffix = target.upper()
                        resource_type = 'mirrors_{}'.format(target)
                    release_job_arrows.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter=job_suffix,
                            parent_job_data=(
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    resource_type,
                                    resource_type.upper(),
                                )
                            )
                        )
                    )
                for target in self.CONFIG_PACKAGES:
                    job_suffix = '{}_CONFIGS'.format(target.upper())
                    resource_type = 'mirrors_{}_configs'.format(target)
                    release_job_arrows.append(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter=job_suffix,
                            parent_job_data=(
                                jg_job_data.ParentDataDict(
                                    "component_resources",
                                    resource_type,
                                    resource_type.upper(),
                                )
                            )
                        )
                    )
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=release_job_arrows,
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable
                    )
                )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                return {}

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name='mirrors_merge_binaries',
                resource_type='MIRRORS_MERGE_BINARIES',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_hyps_binaries',
                resource_type='MIRRORS_HYPS_BINARIES',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_tools_binaries',
                resource_type='MIRRORS_TOOLS_BINARIES',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_wrapper_binaries',
                resource_type='MIRRORS_WRAPPER_BINARIES',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_viewer_binaries',
                resource_type='MIRRORS_VIEWER_BINARIES',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_cmpy',
                resource_type='MIRRORS_CMPY',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_fetcher',
                resource_type='MIRRORS_FETCHER',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_scheduler',
                resource_type='MIRRORS_SCHEDULER',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_cm_configs',
                resource_type='MIRRORS_CM_CONFIGS',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_db_configs',
                resource_type='MIRRORS_DB_CONFIGS',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_fetcher_configs',
                resource_type='MIRRORS_FETCHER_CONFIGS',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_rthub_configs',
                resource_type='MIRRORS_RTHUB_CONFIGS',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_scheduler_configs',
                resource_type='MIRRORS_SCHEDULER_CONFIGS',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_viewer_configs',
                resource_type='MIRRORS_VIEWER_CONFIGS',
            ),
            configs.ReleasedResourceInfo(
                name='mirrors_wrapper_configs',
                resource_type='MIRRORS_WRAPPER_CONFIGS',
            ),
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                "search-components-releases@yandex-team.ru",
            ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "bvshuryg"
            queue = "MIRRORSRELEASE"
            dev_queue = "MIRRORS"
            summary_template = u"Mirrors {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = []
            add_commiters_as_followers = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "robot/mirrors/changelogs/"
        dirs = [
            "arcadia/robot/mirror",
        ]
        review_groups = [
            "mirror",
        ]
