# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg

import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class Botplatform(cfg.ReferenceBranchedConfig):
    name = "botplatform"
    display_name = "Botplatform"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_DOCKER_IMAGE_V6",
                        out={},
                        ctx={
                            "_container": 706571549,
                            "build_type": "release",
                            "use_aapi_fuse": True,
                            "docker_resource_type": "tarball",
                            "docker_package_json": "mssngr/botplatform/docker/docker_package.json",
                            "registry_tags": "mssngr/yamb-bots:1.31.{revision}.{branch}",
                            "registry_login": "robot-mssngr-r-rel",
                            "vault_item_name": "MSSNGR-R-REL_DD_TOKEN",
                            "vault_item_owner": "MSSNGR"
                        },
                        job_arrows=[
                            jg_job_triggers.JobTriggerNewTag([
                                jg_job_data.ParentDataCtx(
                                    "docker_package_checkout_arcadia_from_url",
                                    "checkout_arcadia_from_url"
                                ),
                            ])
                        ],
                    ),
                )
                return branch_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка Botplatform: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/botplatform"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/botplatform"
        dirs = [
            "arcadia/mssngr/botplatform"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        resources_info = []
