# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class CsServer(cfg.ReferenceBranchedConfig):
    name = "cs_server"
    display_name = "Common Stats Server"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_CS_SERVER",
                        build_item="CS_SERVER",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            )
                        ),
                        out={
                            "MSSNGR_CS_SERVER": 90,
                        },
                        ctx={
                            "build_type": "profile",
                            "sym_dump": "61581470",
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_CS_SERVER_CONFIG",
                        build_item="CS_SERVER_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            )
                        ),
                        out={
                            "MSSNGR_CS_SERVER_LOOP_CONF": 90,
                            "MSSNGR_CS_SERVER_CONFIG": 90,
                        },
                        ctx={
                            "build_type": "profile",
                            "sym_dump": "61581470",
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_RTC_FEEDBACK_REASONS",
                        build_item="FEEDBACK_REASONS",
                        out={
                            "FEEDBACK_REASONS": 90,
                        },
                    )
                )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="CS_SERVER",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cs_server",
                                        "MSSNGR_CS_SERVER",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="CS_SERVER_CONFIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "cs_server_config",
                                        "MSSNGR_CS_SERVER_CONFIG",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="FEEDBACK_REASONS",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "feedback_reasons",
                                        "FEEDBACK_REASONS",
                                    ),
                                ),
                            )
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "CS_SERVER"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "CS_SERVER_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "FEEDBACK_REASONS"): rm_const.TestFrequencies.EACH_REV_TEST,

                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка CS Server: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/cs_server"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/cs_server"
        dirs = [
            "arcadia/mssngr/router/daemons/cs_server",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        @property
        def releasable_items(self):
            deploy_infos = [
                ri.NannyDeployInfo(
                    ri.DeployService("production_mssngr_cs_server_yp_{}".format(loc))
                    for loc in rm_const.MAIN_LOCATIONS
                )
            ]
            return [
                ri.ReleasableItem(
                    name="cs_server",
                    data=ri.SandboxResourceData("MSSNGR_CS_SERVER", build_ctx_key="arcadia_url"),
                    deploy_infos=deploy_infos
                ),
                ri.ReleasableItem(
                    name="cs_server_config",
                    data=ri.SandboxResourceData("MSSNGR_CS_SERVER_CONFIG", build_ctx_key="arcadia_url"),
                    deploy_infos=deploy_infos
                ),
                ri.ReleasableItem(
                    name="cs_server_loop_conf",
                    data=ri.SandboxResourceData("MSSNGR_CS_SERVER_LOOP_CONF", build_ctx_key="arcadia_url"),
                ),
                ri.ReleasableItem(
                    name="feedback_reasons",
                    data=ri.SandboxResourceData("FEEDBACK_REASONS", build_ctx_key="arcadia_url"),
                )
            ]
