# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class GDPRDataCollector(cfg.ReferenceBranchedConfig):
    name = "data_collector"
    display_name = "GDPR Data Collector"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "manokk",
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_DATA_COLLECTOR",
                        build_item="DATA_COLLECTOR",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            )
                        ),
                        out={
                            "MSSNGR_DATA_COLLECTOR": 90,
                        },
                        ctx={
                            "build_type": "profile",
                            "sym_dump": "61581470",
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_DATA_COLLECTOR_CONFIG",
                        build_item="DATA_COLLECTOR_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            )
                        ),
                        out={
                            "MSSNGR_DATA_COLLECTOR_TESTING_LOOP_CONF": 90,
                            "MSSNGR_DATA_COLLECTOR_TESTING_CONFIG": 90,
                            "MSSNGR_DATA_COLLECTOR_LOOP_CONF": 90,
                            "MSSNGR_DATA_COLLECTOR_CONFIG": 90,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="DEPLOY_NANNY_DASHBOARD",
                        job_params={
                            "job_name_parameter": "DATA_COLLECTOR_TESTING",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRelease(
                                job_name_parameter=rm_const.ReleaseStatus.testing,
                            ),
                            jg_arrows.ParentsData(
                                input_key="deployment_task_id",
                                triggers=(
                                    jg_job_triggers.JobTriggerBuild(
                                        job_name_parameter="DATA_COLLECTOR",
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="data_collector_id",
                                            ),
                                        )
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        job_name_parameter="DATA_COLLECTOR_CONFIG",
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="data_collector_config_id",
                                            ),
                                        )
                                    ),
                                ),
                                transform=lambda data_collector_id, data_collector_config_id: "{},{}".format(
                                    data_collector_id,
                                    data_collector_config_id,
                                ),
                            )
                        ),
                        ctx={
                            "deployment_nanny_dashboard_filter": "data_collector",
                            "deployment_nanny_dashboard_name": "mssngr_testing",
                            "deployment_nanny_dashboard_recipe": "data_collector_ppsa",
                            "deployment_release_status": rm_const.ReleaseStatus.testing,
                            "deployment_nanny_bool_wait": True,
                            "services_from_recipe": True,
                            "vault_name": "nanny_oauth_token",
                            "vault_owner": "MSSNGR",
                            "wait_deployment": "120",
                        },
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="DATA_COLLECTOR",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "data_collector",
                                            "MSSNGR_DATA_COLLECTOR",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="DATA_COLLECTOR_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "data_collector_config_prod",
                                            "MSSNGR_DATA_COLLECTOR_CONFIG",
                                        ),
                                    ),
                                ),
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DATA_COLLECTOR_TESTING",
                                ) if release_stage == rm_const.ReleaseStatus.testing else None,
                            ),
                        )
                    )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "DATA_COLLECTOR"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "DATA_COLLECTOR_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,

                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка GDPR Data Collector: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/data_collector"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/data_collector"
        dirs = [
            "arcadia/mssngr/router/daemons/data_collector",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        @property
        def releasable_items(self):
            nanny_prod = ri.NannyDeployInfo(
                ri.DeployService("production_mssngr_data_collector_yp_{}".format(loc)) for loc in ["vla", "man"]
            )
            nanny_testing = ri.NannyDeployInfo(
                [
                    ri.DeployService("testing_mssngr_data_collector_yp_{}".format(loc))
                    for loc in ["vla"]  # the other two locations went offline
                ],
                stage=rm_const.ReleaseStatus.testing
            )
            return [
                ri.ReleasableItem(
                    name="data_collector",
                    data=ri.SandboxResourceData("MSSNGR_DATA_COLLECTOR", build_ctx_key="arcadia_url"),
                    deploy_infos=[nanny_prod, nanny_testing]
                ),
                ri.ReleasableItem(
                    name="data_collector_config_prod",
                    data=ri.SandboxResourceData("MSSNGR_DATA_COLLECTOR_CONFIG", build_ctx_key="arcadia_url"),
                    deploy_infos=[nanny_prod]
                ),
                ri.ReleasableItem(
                    name="data_collector_config_testing",
                    data=ri.SandboxResourceData("MSSNGR_DATA_COLLECTOR_TESTING_CONFIG", build_ctx_key="arcadia_url"),
                    deploy_infos=[nanny_testing]
                ),
                ri.ReleasableItem(
                    name="data_collector_loop_conf_prod",
                    data=ri.SandboxResourceData("MSSNGR_DATA_COLLECTOR_LOOP_CONF", build_ctx_key="arcadia_url"),
                ),
                ri.ReleasableItem(
                    name="data_collector_loop_conf_testing",
                    data=ri.SandboxResourceData("MSSNGR_DATA_COLLECTOR_TESTING_LOOP_CONF", build_ctx_key="arcadia_url"),
                ),
            ]
