# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class Fanout(cfg.ReferenceBranchedConfig):
    name = "fanout"
    display_name = "Fanout (balancer and workers)"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                balancer_out = {"MSSNGR_ROUTER_BALANCER": 90}
                worker_out = {"MSSNGR_ROUTER_STATE_CACHER": 90, "MSSNGR_ROUTER_WORKER": 90}
                for build_type in ["BALANCER", "WORKER"]:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_MSSNGR_ROUTER_{}".format(build_type),
                            build_item=build_type,
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="arcadia_url",
                                            output_key=sandbox_constants.ARCADIA_URL_KEY,
                                        ),
                                    ),
                                ),
                            ),
                            out=balancer_out if build_type == "BALANCER" else worker_out,
                            ctx={
                                "build_type": "profile",
                                "sym_dump": "61581470",
                            },
                        )
                    )
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_MSSNGR_ROUTER_{}_CONFIG".format(build_type),
                            build_item="{}_CONFIG".format(build_type),
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="arcadia_url",
                                            output_key=sandbox_constants.ARCADIA_URL_KEY,
                                        ),
                                    ),
                                ),
                            ),
                            out={
                                "MSSNGR_ROUTER_{}_ALPHA_LOOP_CONF".format(build_type): 90,
                                "MSSNGR_ROUTER_{}_ALPHA_CONFIG".format(build_type): 90,
                                "MSSNGR_ROUTER_{}_TESTING_LOOP_CONF".format(build_type): 90,
                                "MSSNGR_ROUTER_{}_TESTING_CONFIG".format(build_type): 90,
                                "MSSNGR_ROUTER_{}_LOOP_CONF".format(build_type): 90,
                                "MSSNGR_ROUTER_{}_CONFIG".format(build_type): 90,
                            },
                        )
                    )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_ROUTER_STATE_CACHE_TOOLS",
                        build_item="STATE_CACHE_TOOLS",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_ROUTER_STATE_CACHE_UPDATER": 90,
                            "MSSNGR_ROUTER_STATE_CACHE_PUSHER": 90,
                        },
                    )
                )

                for build_type in ["WORKER", "BALANCER"]:
                    for release_type in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.prestable]:
                        if release_type == rm_const.ReleaseStatus.prestable:
                            deployment_nanny_dashboard_name = "mssngr_alpha"
                        else:
                            deployment_nanny_dashboard_name = "mssngr_testing"
                        branch_part.append(
                            jg_test.JobGraphElementTestBranchCommon(
                                task_name="DEPLOY_NANNY_DASHBOARD",
                                job_params={
                                    "job_name_parameter": "DEPLOY_{}_{}".format(build_type, release_type.upper()),
                                },
                                job_arrows=(
                                    jg_arrows.ParentsData(
                                        input_key="deployment_task_id",
                                        triggers=(
                                            jg_job_triggers.JobTriggerBuild(
                                                job_name_parameter=build_type,
                                                parent_job_data=(
                                                    jg_job_data.ParentDataId(
                                                        input_key="fanout_id",
                                                    ),
                                                ),
                                            ),
                                            jg_job_triggers.JobTriggerBuild(
                                                job_name_parameter="{}_CONFIG".format(build_type),
                                                parent_job_data=(
                                                    jg_job_data.ParentDataId(
                                                        input_key="fanout_config_id",
                                                    ),
                                                ),
                                            ),
                                            jg_job_triggers.JobTriggerBuild(
                                                job_name_parameter="STATE_CACHE_TOOLS",
                                                parent_job_data=(
                                                    jg_job_data.ParentDataId(
                                                        input_key="fanout_tools_id",
                                                    ),
                                                ),
                                            ) if build_type == "WORKER" else None,
                                        ),
                                        transform=lambda fanout_id, fanout_config_id, fanout_tools_id="": ",".join(
                                            map(str, filter(None, [
                                                fanout_id,
                                                fanout_config_id,
                                                fanout_tools_id,
                                            ]))
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerRelease(
                                        job_name_parameter=release_type,
                                    ),
                                ),
                                ctx={
                                    "deployment_nanny_dashboard_filter": "router_{}s".format(build_type.lower()),
                                    "deployment_nanny_dashboard_name": deployment_nanny_dashboard_name,
                                    "deployment_nanny_dashboard_recipe": "router_{}s_ppsa".format(build_type.lower()),
                                    "deployment_release_status": release_type,
                                    "deployment_nanny_bool_wait": True,
                                    "services_from_recipe": True,
                                    "vault_name": "nanny_oauth_token",
                                    "vault_owner": "MSSNGR",
                                    "wait_deployment": "120",
                                }
                            )
                        )
                for release_type in [rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.testing]:
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="GENERIC_TESTS_ANDROID_LAUNCHER",
                            job_params={
                                "job_name_parameter": "LAUNCH_{}_ANDROID_TESTS".format(release_type.upper()),
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_WORKER_{}".format(release_type.upper()),
                                ),
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_BALANCER_{}".format(release_type.upper()),
                                ),
                            ),
                            ctx={
                                "tasks_reports_dir_param_name": "gradle.input.dir",
                                "vcs_url": "https://bitbucket.browser.yandex-team.ru/scm/ml/mobile-alice-library-android.git",
                                "pass_logs_to_teamcity": False,
                                "delegate_emulator_launch": False,
                                "build_target": ["bricks:assembleAndroidTest", "messenger:systemtest:assembleAndroidTest"],
                                "optimization_group": None,
                                "use_latest_revision": False,
                                "vcs_group": None,
                                "tests_resource": None,
                                "system_gradle_parameters": {},
                                "dont_need_root": False,
                                "secret_gradle_parameters": {},
                                "ssh_key": "MSSNGR:mssngr-r-rel__ssh_key",
                                "use_new_git_helper": False,
                                "build_agent_parameters_group": None,
                                "pass_reports_to_teamcity": False,
                                "advanced_devices_config": ["API28_480_1080x1920_default"],
                                "need_git_lfs": False,
                                "report_target": [],
                                "retry_count": 0,
                                "output_dir_param_name": "sandbox.outputDir",
                                "aggregated_reports": {"Aggregated Report": "aggregated_allure_report/index.html"},
                                "aggregated_report_parameters": None,
                                "report_duration": 10,
                                "teamcity_group": None,
                                "use_ssd": False,
                                "time_to_kill": 10800,
                                "launch_xvfb": True,
                                "gradle_group": None,
                                "test_parameters_group": None,
                                "other_parameters_group": None,
                                "teamcity_artifact_paths": {},
                                "run_target": ["bricks:spoonDebugAndroidTest", "messenger:systemtest:spoonReleaseAndroidTest"],
                                "multislot_type": "2",
                                "gradle_log_level": "--info",
                                "branch": "dev",
                                "gradle_parameters": {"testBuildType": "release", "android.enableR8": "False", "android.useProguard": "False"},
                                "platform_specific_parameters_group": None,
                                "aggregated_reports_dir_param_name": "gradle.output.dir",
                                "api_levels": [
                                    "17_google_apis",
                                    "19_google_apis",
                                    "22_google_apis",
                                    "22_default",
                                    "23_google_apis",
                                    "23_default",
                                    "24_google_apis",
                                    "24_default",
                                    "25_google_apis",
                                    "25_default",
                                    "26_google_apis",
                                    "26_default",
                                    "27_google_apis",
                                    "27_default",
                                    "28_google_apis",
                                    "28_default",
                                ],
                                "execute_if_failed": True,
                                "reports": {
                                    "Bricks": "bricks/debug/index.html",
                                    "Systemtest": "systemtest/release/index.html",
                                },
                                "use_tmpfs": False,
                                "container_version": "stable",
                            }
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="MSSNGR_ROUTER_LOAD_TEST",
                        job_params={
                            "job_name_parameter": "LOAD_TEST",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_WORKER_{}".format(rm_const.ReleaseStatus.testing.upper()),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_BALANCER_{}".format(rm_const.ReleaseStatus.testing.upper()),
                            ),
                        ),
                        ctx={
                            "st_token_secret": "",
                            "yasm_chart": "template/panel/mssngr_load_test",
                        },
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BALANCER",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="balancer",
                                            resource_name="MSSNGR_ROUTER_BALANCER",
                                        ),
                                    )
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BALANCER_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="balancer_config_prod",
                                            resource_name="MSSNGR_ROUTER_BALANCER_CONFIG",
                                        ),
                                    )
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="WORKER",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="worker",
                                            resource_name="MSSNGR_ROUTER_WORKER",
                                        ),
                                    )
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="WORKER_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="worker_config_prod",
                                            resource_name="MSSNGR_ROUTER_WORKER_CONFIG",
                                        ),
                                    )
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="STATE_CACHE_TOOLS",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="state_cache_updater",
                                            resource_name="MSSNGR_ROUTER_STATE_CACHE_UPDATER",
                                        ),
                                    )
                                ),
                            )
                        )
                    )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.testing,
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_WORKER_{}".format(rm_const.ReleaseStatus.testing),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_BALANCER_{}".format(rm_const.ReleaseStatus.testing),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="LAUNCH_{}_ANDROID_TESTS".format(rm_const.ReleaseStatus.testing),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="LOAD_TEST",
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.prestable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_WORKER_{}".format(rm_const.ReleaseStatus.prestable),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="DEPLOY_BALANCER_{}".format(rm_const.ReleaseStatus.prestable),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="LAUNCH_{}_ANDROID_TESTS".format(rm_const.ReleaseStatus.prestable),
                            ),
                        )
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "BALANCER"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "BALANCER_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "WORKER"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "WORKER_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка Fanout: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/router"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/fanout"
        dirs = [
            "arcadia/mssngr/router/daemons/balancer",
            "arcadia/mssngr/router/daemons/router",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        resources_info = [
            cfg.ReleasedResourceInfo(
                name="balancer",  # Arbitrary identifier of release item
                resource_type="MSSNGR_ROUTER_BALANCER",  # Resource type
                resource_name="balancer",  # different from other resource's name
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_router_balancers_yp_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_router_balancers_yp_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_router_balancers_yp_man")

                ]

            ),
            cfg.ReleasedResourceInfo(
                name="balancer_loop_conf_prod",
                resource_type="MSSNGR_ROUTER_BALANCER_LOOP_CONF",
                resource_name="balancer_loop_conf_prod",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="balancer_loop_conf_testing",
                resource_type="MSSNGR_ROUTER_BALANCER_TESTING_LOOP_CONF",
                resource_name="balancer_loop_conf_testing",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="balancer_config_prod",
                resource_type="MSSNGR_ROUTER_BALANCER_CONFIG",
                resource_name="balancer_config_prod",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_router_balancers_yp_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="balancer_config_testing",
                resource_type="MSSNGR_ROUTER_BALANCER_TESTING_CONFIG",
                resource_name="balancer_config_testing",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_router_balancers_yp_man")

                ]
            ),
            cfg.ReleasedResourceInfo(
                name="balancer_config_alpha",
                resource_type="MSSNGR_ROUTER_BALANCER_ALPHA_CONFIG",
                resource_name="balancer_config_alpha",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_router_balancers_yp_man"),
                ]
            ),
            # worker configs
            cfg.ReleasedResourceInfo(
                name="worker",
                resource_type="MSSNGR_ROUTER_WORKER",
                resource_name="worker",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_router_workers_yp_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_router_workers_yp_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_router_workers_yp_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="state_cacher",
                resource_type="MSSNGR_ROUTER_STATE_CACHER",
                resource_name="state_cacher",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="worker_loop_conf_prod",
                resource_type="MSSNGR_ROUTER_WORKER_LOOP_CONF",
                resource_name="worker_loop_conf_prod",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="worker_loop_conf_testing",
                resource_type="MSSNGR_ROUTER_WORKER_TESTING_LOOP_CONF",
                resource_name="worker_loop_conf_testing",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="worker_loop_conf_alpha",
                resource_type="MSSNGR_ROUTER_WORKER_ALPHA_LOOP_CONF",
                resource_name="worker_loop_conf_alpha",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="worker_config_prod",
                resource_type="MSSNGR_ROUTER_WORKER_CONFIG",
                resource_name="worker_config_prod",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_router_workers_yp_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="worker_config_testing",
                resource_type="MSSNGR_ROUTER_WORKER_TESTING_CONFIG",
                resource_name="worker_config_testing",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_router_workers_yp_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="worker_config_alpha",
                resource_type="MSSNGR_ROUTER_WORKER_ALPHA_CONFIG",
                resource_name="worker_config_alpha",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_router_workers_yp_man")
                ]
            ),
            # state cacher
            cfg.ReleasedResourceInfo(
                name="state_cache_updater",
                resource_type="MSSNGR_ROUTER_STATE_CACHE_UPDATER",
                resource_name="state_cache_updater",
                build_ctx_key="arcadia_url"
            ),
            cfg.ReleasedResourceInfo(
                name="state_cache_pusher",
                resource_type="MSSNGR_ROUTER_STATE_CACHE_PUSHER",
                resource_name="state_cache_pusher",
                build_ctx_key="arcadia_url"
            ),
        ]
