# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class FilesCfg(cfg.ReferenceBranchedConfig):
    name = "files"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_FILES",
                        build_item="FILES",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_FILES": 90
                        },
                        ctx={
                            "build_type": "release",
                            "sym_dump": "61581470",
                        },
                    )
                )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_STICKERS",
                        build_item="STICKERS",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_STICKERS": 90
                        },
                        ctx={
                            "build_type": "release",
                            "sym_dump": "61581470",
                        },
                    )
                )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_FILES_CONFIG",
                        build_item="FILES_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_FILES_CONF_LOCAL_ALPHA_CONFIG": 90,
                            "MSSNGR_FILES_ALPHA_LOOP_CONF": 90,
                            "MSSNGR_FILES_ALPHA_CONFIG": 90,
                            "MSSNGR_FILES_CONF_LOCAL_TESTING_CONFIG": 90,
                            "MSSNGR_FILES_TESTING_LOOP_CONF": 90,
                            "MSSNGR_FILES_TESTING_CONFIG": 90,
                            "MSSNGR_FILES_CONF_LOCAL_CONFIG": 90,
                            "MSSNGR_FILES_LOOP_CONF": 90,
                            "MSSNGR_FILES_CONFIG": 90,
                        },
                    )
                )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_STICKERS_CONFIG",
                        build_item="STICKERS_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_STICKERS_CONFIG": 90,
                            "MSSNGR_STICKERS_ALPHA_CONFIG": 90,
                            "MSSNGR_STICKERS_TESTING_CONFIG": 90,
                        },
                    )
                )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_YAMB_CODE_BUNDLE",
                        build_item="YAMB_CODE_BUNDLE",
                        job_arrows=(),
                        out={
                            "MSSNGR_FILES_CODE_BUNDLE": 90,
                        },
                        ctx={
                            "git_url": "ssh://git@bitbucket.browser.yandex-team.ru/mssngr/messenger-backend-history.git",
                            "vault_owner": "MSSNGR",
                            "vault_key": "mssngr-r-rel__ssh_key",
                            "is_registry_build": False

                        },
                    )
                )

                deploy_mapping = [
                    (
                        rm_const.ReleaseStatus.testing, "mssngr_testing", "files_ppsa",
                        "files", "DEPLOY_FILES_{}"
                    ),
                    (
                        rm_const.ReleaseStatus.prestable, "mssngr_alpha", "files_ppsa",
                        "files", "DEPLOY_FILES_{}"
                    ),
                ]
                for release_type, dashboard_name, recipe_name, dashboard_section, test_name in deploy_mapping:
                    deploy_files_job_arrows = (
                        jg_arrows.ParentsData(
                            input_key="deployment_task_id",
                            triggers=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="FILES",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="files_id",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="FILES_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="files_config_id",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="STICKERS",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="stickers_id",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="STICKERS_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="stickers_config_id",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="YAMB_CODE_BUNDLE",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="yamb_code_bundle_id",
                                        ),
                                    ),
                                ),
                            ),
                            transform=lambda files_id, files_config_id, stickers_id, stickers_config_id, yamb_code_bundle_id: ",".join(
                                map(str, [
                                    files_id,
                                    files_config_id,
                                    stickers_id,
                                    stickers_config_id,
                                    yamb_code_bundle_id
                                ])
                            ),
                        ),
                        jg_job_triggers.JobTriggerRelease(
                            job_name_parameter=release_type,
                        ),
                    )
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_NANNY_DASHBOARD",
                            job_params={
                                "job_name_parameter": test_name.format(release_type.upper()),
                            },
                            job_arrows=deploy_files_job_arrows,
                            ctx={
                                "deployment_nanny_dashboard_filter": dashboard_section,
                                "deployment_nanny_dashboard_name": dashboard_name,
                                "deployment_nanny_dashboard_recipe": recipe_name,
                                "deployment_release_status": release_type,
                                "deployment_nanny_bool_wait": True,
                                "services_from_recipe": True,
                                "vault_name": "nanny_oauth_token",
                                "vault_owner": "MSSNGR",
                                "wait_deployment": "120",
                            },
                        )
                    )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release

                release_job_arrows = {}
                release_job_arrows[rm_const.ReleaseStatus.testing] = (
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="FILES_CONFIG",
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="files_config_testing",
                                resource_name="MSSNGR_FILES_TESTING_CONFIG",
                            ),
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="files_loop_conf_testing",
                                resource_name="MSSNGR_FILES_TESTING_LOOP_CONF",
                            ),
                        ),
                    ),
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="STICKERS_CONFIG",
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="stickers_config_testing",
                                resource_name="MSSNGR_STICKERS_TESTING_CONFIG",
                            ),
                        ),
                    ),
                )

                release_job_arrows[rm_const.ReleaseStatus.prestable] = (
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="FILES_CONFIG",
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="files_config_alpha",
                                resource_name="MSSNGR_FILES_ALPHA_CONFIG",
                            ),
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="files_loop_conf_alpha",
                                resource_name="MSSNGR_FILES_ALPHA_LOOP_CONF",
                            ),
                        ),
                    ),
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="STICKERS_CONFIG",
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="stickers_config_alpha",
                                resource_name="MSSNGR_STICKERS_ALPHA_CONFIG",
                            ),
                        ),
                    ),
                )

                release_job_arrows[rm_const.ReleaseStatus.stable] = (
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="FILES_CONFIG",
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="files_config_prod",
                                resource_name="MSSNGR_FILES_CONFIG",
                            ),
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="files_loop_conf_prod",
                                resource_name="MSSNGR_FILES_LOOP_CONF",
                            ),
                        ),
                    ),
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter="STICKERS_CONFIG",
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                input_key="component_resources",
                                dict_key="stickers_config_prod",
                                resource_name="MSSNGR_STICKERS_CONFIG",
                            ),
                        ),
                    ),
                )

                for release_stage in [
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=release_job_arrows[release_stage] + (
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="FILES",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="files",
                                            resource_name="MSSNGR_FILES",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="STICKERS",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="stickers",
                                            resource_name="MSSNGR_STICKERS",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="YAMB_CODE_BUNDLE",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="files_yamb_code_bundle",
                                            resource_name="MSSNGR_FILES_CODE_BUNDLE",
                                        ),
                                    ),
                                ),
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_FILES_{}".format(release_stage.upper()),
                                ) if release_stage != rm_const.ReleaseStatus.stable else None,
                            ),
                        )
                    )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "FILES"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "FILES_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "STICKERS"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "STICKERS_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "YAMB_CODE_BUNDLE"): rm_const.TestFrequencies.EACH_REV_TEST,

                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка Files: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/files"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/files"
        dirs = [
            "arcadia/mssngr/router/daemons/files",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        resources_info = [
            cfg.ReleasedResourceInfo(
                name="files",  # Arbitrary identifier of release item
                resource_type="MSSNGR_FILES",  # Resource type
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_files_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_files_man"),
                    (rm_const.ReleaseStatus.stable, "production_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="stickers",  # Arbitrary identifier of release item
                resource_type="MSSNGR_STICKERS",  # Resource type
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_files_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_files_man"),
                    (rm_const.ReleaseStatus.stable, "production_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_yamb_code_bundle",  # Arbitrary identifier of release item
                resource_type="MSSNGR_FILES_CODE_BUNDLE",  # Resource type
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_files_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_files_man"),
                    (rm_const.ReleaseStatus.stable, "production_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_config_prod",
                resource_type="MSSNGR_FILES_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_config_testing",
                resource_type="MSSNGR_FILES_TESTING_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_files_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_config_alpha",
                resource_type="MSSNGR_FILES_ALPHA_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_loop_conf_prod",
                resource_type="MSSNGR_FILES_LOOP_CONF",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_loop_conf_testing",
                resource_type="MSSNGR_FILES_TESTING_LOOP_CONF",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_files_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="files_loop_conf_alpha",
                resource_type="MSSNGR_FILES_ALPHA_LOOP_CONF",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_files_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="stickers_config_prod",
                resource_type="MSSNGR_STICKERS_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="stickers_config_testing",
                resource_type="MSSNGR_STICKERS_TESTING_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_files_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="stickers_config_alpha",
                resource_type="MSSNGR_STICKERS_ALPHA_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_files_man"),
                ]
            ),
        ]
