# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class Geobot(cfg.ReferenceBranchedConfig):
    name = "geobot"
    display_name = "Geobot"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_GEO_BOT",
                        build_item="GEOBOT",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_GEO_BOT": 90,
                        },
                        ctx={
                            "build_type": "profile",
                            "sym_dump": "61581470",
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_GEO_BOT_CONFIG",
                        build_item="GEOBOT_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_GEO_BOT_ALPHA_LOOP_CONF": 90,
                            "MSSNGR_GEO_BOT_ALPHA_CONFIG": 90,
                            "MSSNGR_GEO_BOT_TESTING_LOOP_CONF": 90,
                            "MSSNGR_GEO_BOT_TESTING_CONFIG": 90,
                            "MSSNGR_GEO_BOT_LOOP_CONF": 90,
                            "MSSNGR_GEO_BOT_CONFIG": 90,
                        },
                    )
                )

                for release_type in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.prestable]:
                    if release_type == rm_const.ReleaseStatus.prestable:
                        deployment_nanny_dashboard_name = "mssngr_alpha"
                    else:
                        deployment_nanny_dashboard_name = "mssngr_testing"
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_NANNY_DASHBOARD",
                            job_params={
                                "job_name_parameter": "DEPLOY_{}".format(release_type),
                            },
                            job_arrows=(
                                jg_arrows.ParentsData(
                                    input_key="deployment_task_id",
                                    triggers=(
                                        jg_job_triggers.JobTriggerBuild(
                                            job_name_parameter="GEOBOT",
                                            parent_job_data=(
                                                jg_job_data.ParentDataId(
                                                    input_key="geobot_id",
                                                ),
                                            ),
                                        ),
                                        jg_job_triggers.JobTriggerBuild(
                                            job_name_parameter="GEOBOT_CONFIG",
                                            parent_job_data=(
                                                jg_job_data.ParentDataId(
                                                    input_key="geobot_config_id",
                                                ),
                                            ),
                                        ),
                                    ),
                                    transform=lambda geobot_id, geobot_config_id: ",".join(map(str, [
                                        geobot_id,
                                        geobot_config_id,
                                    ])),
                                ),
                                jg_job_triggers.JobTriggerRelease(
                                    job_name_parameter=release_type,
                                ),
                            ),
                            ctx={
                                "deployment_nanny_dashboard_filter": "geobot",
                                "deployment_nanny_dashboard_name": deployment_nanny_dashboard_name,
                                "deployment_nanny_dashboard_recipe": "geobot_ppsa",
                                "deployment_release_status": release_type,
                                "deployment_nanny_bool_wait": True,
                                "services_from_recipe": True,
                                "vault_name": "nanny_oauth_token",
                                "vault_owner": "MSSNGR",
                                "wait_deployment": "120",
                            }
                        )
                    )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="GEOBOT",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "geobot",
                                            "MSSNGR_GEO_BOT",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="GEOBOT_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "geobot_config_prod",
                                            "MSSNGR_GEO_BOT_CONFIG",
                                        ),
                                    ),
                                ),
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_{}".format(release_stage),
                                ) if release_stage != rm_const.ReleaseStatus.stable else None,
                            ),
                        )
                    )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "GEOBOT"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "GEOBOT_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка GeoBot: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/geobot"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/geobot"
        dirs = [
            "arcadia/mssngr/router/daemons/geobot",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        resources_info = [
            cfg.ReleasedResourceInfo(
                name="geobot",  # Arbitrary identifier of release item
                resource_type="MSSNGR_GEO_BOT",  # Resource type
                resource_name="geobot",  # different from other resource's name
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_geobot_vla"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_geobot_vla"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_geobot_sas")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="geobot_loop_conf_prod",
                resource_type="MSSNGR_GEO_BOT_LOOP_CONF",
                resource_name="geobot_loop_conf_prod",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="geobot_loop_conf_alpha",
                resource_type="MSSNGR_GEO_BOT_ALPHA_LOOP_CONF",
                resource_name="geobot_loop_conf_alpha",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="geobot_loop_conf_testing",
                resource_type="MSSNGR_GEO_BOT_TESTING_LOOP_CONF",
                resource_name="geobot_loop_conf_testing",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="geobot_config_prod",
                resource_type="MSSNGR_GEO_BOT_CONFIG",
                resource_name="geobot_config_prod",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_geobot_sas"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="geobot_config_testing",
                resource_type="MSSNGR_GEO_BOT_TESTING_CONFIG",
                resource_name="geobot_config_testing",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_geobot_sas")

                ]
            ),
            cfg.ReleasedResourceInfo(
                name="geobot_config_alpha",
                resource_type="MSSNGR_GEO_BOT_ALPHA_CONFIG",
                resource_name="geobot_config_alpha",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_geobot_sas"),
                ]
            ),
        ]
