# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class Metasearch(cfg.ReferenceBranchedConfig):
    name = "metasearch"
    display_name = "Metasearch"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_METASEARCH",
                        build_item="METASEARCH",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_METASEARCH": 90,
                        },
                        ctx={
                            "build_type": "profile",
                            "sym_dump": "61581470",
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_METASEARCH_CONFIG",
                        build_item="METASEARCH_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_METASEARCH_ALPHA_LOOP_CONF": 90,
                            "MSSNGR_METASEARCH_ALPHA_CONFIG": 90,
                            "MSSNGR_METASEARCH_TESTING_LOOP_CONF": 90,
                            "MSSNGR_METASEARCH_TESTING_CONFIG": 90,
                            "MSSNGR_METASEARCH_LOOP_CONF": 90,
                            "MSSNGR_METASEARCH_CONFIG": 90,
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_GEOBASE",
                        build_item="METASEARCH_GEOBASE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_GEOBASE": 90
                        },
                        ctx={
                            "build_type": "profile",
                            "sym_dump": "61581470",
                        },
                    )
                )

                for release_type in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.prestable]:
                    if release_type == rm_const.ReleaseStatus.prestable:
                        deployment_nanny_dashboard_name = "mssngr_alpha"
                    else:
                        deployment_nanny_dashboard_name = "mssngr_testing"
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_NANNY_DASHBOARD",
                            job_params={
                                "job_name_parameter": "DEPLOY_METASEARCH_{}".format(release_type.upper()),
                            },
                            job_arrows=(
                                jg_arrows.ParentsData(
                                    input_key="deployment_task_id",
                                    triggers=(
                                        jg_job_triggers.JobTriggerBuild(
                                            job_name_parameter="METASEARCH",
                                            parent_job_data=(
                                                jg_job_data.ParentDataId(
                                                    input_key="metasearch_id",
                                                ),
                                            ),
                                        ),
                                        jg_job_triggers.JobTriggerBuild(
                                            job_name_parameter="METASEARCH_CONFIG",
                                            parent_job_data=(
                                                jg_job_data.ParentDataId(
                                                    input_key="metasearch_config_id",
                                                ),
                                            ),
                                        ),
                                        jg_job_triggers.JobTriggerBuild(
                                            job_name_parameter="METASEARCH_GEOBASE",
                                            parent_job_data=(
                                                jg_job_data.ParentDataId(
                                                    input_key="metasearch_geobase_id",
                                                ),
                                            ),
                                        ),
                                    ),
                                    transform=lambda metasearch_id, metasearch_config_id, metasearch_geobase_id: ",".join(
                                        map(str, [
                                            metasearch_id,
                                            metasearch_config_id,
                                            metasearch_geobase_id,
                                        ])
                                    ),
                                ),
                                jg_job_triggers.JobTriggerRelease(
                                    job_name_parameter=release_type,
                                ),
                            ),
                            ctx={
                                "deployment_nanny_dashboard_filter": "metasearch",
                                "deployment_nanny_dashboard_name": deployment_nanny_dashboard_name,
                                "deployment_nanny_dashboard_recipe": "metasearch_ppsa",
                                "deployment_release_status": release_type,
                                "deployment_nanny_bool_wait": True,
                                "services_from_recipe": True,
                                "vault_name": "nanny_oauth_token",
                                "vault_owner": "MSSNGR",
                                "wait_deployment": "120",
                            },
                        )
                    )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="METASEARCH",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="metasearch",
                                            resource_name="MSSNGR_METASEARCH",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="METASEARCH_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="metasearch_config_prod",
                                            resource_name="MSSNGR_METASEARCH_CONFIG",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="METASEARCH_GEOBASE",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="geobase",
                                            resource_name="MSSNGR_GEOBASE",
                                        ),
                                    ),
                                ),
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_METASEARCH_{}".format(release_stage.upper()),
                                ) if release_stage != rm_const.ReleaseStatus.stable else None,
                            ),
                        )
                    )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "METASEARCH"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "METASEARCH_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "METASEARCH_GEOBASE"): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка Fanout: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/metasearch"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/metasearch"
        dirs = [
            "arcadia/mssngr/router/daemons/metasearch",
            "arcadia/mssngr/router/daemons/geobase",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        resources_info = [
            cfg.ReleasedResourceInfo(
                name="metasearch",  # Arbitrary identifier of release item
                resource_type="MSSNGR_METASEARCH",  # Resource type
                resource_name="metasearch",  # different from other resource's name
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_metasearch_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_metasearch_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_metasearch_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="metasearch_loop_conf_prod",
                resource_type="MSSNGR_METASEARCH_LOOP_CONF",
                resource_name="metasearch_loop_conf_prod",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="metasearch_loop_conf_testing",
                resource_type="MSSNGR_METASEARCH_TESTING_LOOP_CONF",
                resource_name="metasearch_loop_conf_testing",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="metasearch_config_prod",
                resource_type="MSSNGR_METASEARCH_CONFIG",
                resource_name="metasearch_config_prod",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_metasearch_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="metasearch_config_testing",
                resource_type="MSSNGR_METASEARCH_TESTING_CONFIG",
                resource_name="metasearch_config_testing",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_metasearch_man")

                ]
            ),
            cfg.ReleasedResourceInfo(
                name="metasearch_config_alpha",
                resource_type="MSSNGR_METASEARCH_ALPHA_CONFIG",
                resource_name="metasearch_config_alpha",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_metasearch_man"),
                ]
            ),
            # geobase
            cfg.ReleasedResourceInfo(
                name="geobase",
                resource_type="MSSNGR_GEOBASE",
                resource_name="geobase",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_metasearch_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_metasearch_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_metasearch_man")
                ]
            ),
        ]
