# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class RegistryCfg(cfg.ReferenceBranchedConfig):
    name = "registry"
    responsible = "manokk"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MSSNGR"
        testenv_db_owners = [
            "thorfinn",
            "chmerev",
            "manokk",
        ]

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_REGISTRY",
                        build_item="REGISTRY",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_REGISTRY": 90,
                            "MSSNGR_CONTACTS_INDEXER": 90,
                        },
                        ctx={
                            "build_type": "release",
                            "sym_dump": "61581470",
                        },
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_REGISTRY_CONFIG",
                        build_item="REGISTRY_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="arcadia_url",
                                        output_key=sandbox_constants.ARCADIA_URL_KEY,
                                    ),
                                ),
                            ),
                        ),
                        out={
                            "MSSNGR_YAMB_CONF_LOCAL_ALPHA_CONFIG": 90,
                            "MSSNGR_YAMB_INTERNAL_CONF_LOCAL_ALPHA_CONFIG": 90,
                            "MSSNGR_REGISTRY_ALPHA_LOOP_CONF": 90,
                            "MSSNGR_REGISTRY_INTERNAL_ALPHA_LOOP_CONF": 90,
                            "MSSNGR_REGISTRY_ALPHA_CONFIG": 90,
                            "MSSNGR_REGISTRY_INTERNAL_ALPHA_CONFIG": 90,
                            "MSSNGR_YAMB_CONF_LOCAL_TESTING_CONFIG": 90,
                            "MSSNGR_REGISTRY_TESTING_LOOP_CONF": 90,
                            "MSSNGR_REGISTRY_TESTING_CONFIG": 90,
                            "MSSNGR_YAMB_INTERNAL_CONF_LOCAL_CONFIG": 90,
                            "MSSNGR_YAMB_CONF_LOCAL_CONFIG": 90,
                            "MSSNGR_REGISTRY_LOOP_CONF": 90,
                            "MSSNGR_REGISTRY_INTERNAL_LOOP_CONF": 90,
                            "MSSNGR_REGISTRY_CONFIG": 90,
                            "MSSNGR_REGISTRY_INTERNAL_CONFIG": 90,
                        },
                    )
                )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MSSNGR_YAMB_CODE_BUNDLE",
                        build_item="YAMB_CODE_BUNDLE",
                        job_arrows=(),
                        out={
                            "MSSNGR_YAMB_CODE_BUNDLE": 90,
                        },
                        ctx={
                            "git_url": "ssh://git@bitbucket.browser.yandex-team.ru/mssngr/messenger-backend-history.git",
                            "vault_owner": "MSSNGR",
                            "vault_key": "mssngr-r-rel__ssh_key"
                        },
                    )
                )

                deploy_mapping = [
                    (
                        rm_const.ReleaseStatus.testing, "mssngr_testing", "registry_ppsa",
                        "registry", "DEPLOY_REGISTRY_{}"
                    ),
                    (
                        rm_const.ReleaseStatus.prestable, "mssngr_alpha", "registry_ppsa",
                        "registry", "DEPLOY_REGISTRY_{}"
                    ),
                    (
                        rm_const.ReleaseStatus.prestable, "mssngr_alpha", "registry_internal_ppsa",
                        "registry_internal", "DEPLOY_REGISTRY_INTERNAL_{}"
                    )
                ]
                android_test_mapping = {}
                for release_type, dashboard_name, recipe_name, dashboard_section, test_name in deploy_mapping:
                    android_test_mapping.setdefault(release_type, [])
                    android_test_mapping[release_type].append(test_name.format(release_type.upper()))
                    deploy_registry_job_arrows = (
                        jg_arrows.ParentsData(
                            input_key="deployment_task_id",
                            triggers=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="REGISTRY",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="registry_id",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="REGISTRY_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="registry_config_id",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="YAMB_CODE_BUNDLE",
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="yamb_code_bundle_id",
                                        ),
                                    ),
                                ),
                            ),
                            transform=lambda registry_id, registry_config_id, yamb_code_bundle_id: ",".join(
                                map(str, [
                                    registry_id,
                                    registry_config_id,
                                    yamb_code_bundle_id
                                ])
                            ),
                        ),
                        jg_job_triggers.JobTriggerRelease(
                            job_name_parameter=release_type,
                        ),
                    )
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_NANNY_DASHBOARD",
                            job_params={
                                "job_name_parameter": test_name.format(release_type.upper()),
                            },
                            job_arrows=deploy_registry_job_arrows,
                            ctx={
                                "deployment_nanny_dashboard_filter": dashboard_section,
                                "deployment_nanny_dashboard_name": dashboard_name,
                                "deployment_nanny_dashboard_recipe": recipe_name,
                                "deployment_release_status": release_type,
                                "deployment_nanny_bool_wait": True,
                                "services_from_recipe": True,
                                "vault_name": "nanny_oauth_token",
                                "vault_owner": "MSSNGR",
                                "wait_deployment": "120",
                            },
                        )
                    )

                for release_type, test_names in android_test_mapping.items():
                    job_arrows = [
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            job_name_parameter=test_name,
                        ) for test_name in test_names
                    ]
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="GENERIC_TESTS_ANDROID_LAUNCHER",
                            job_params={
                                "job_name_parameter": "LAUNCH_{}_ANDROID_TESTS".format(release_type.upper()),
                            },
                            job_arrows=job_arrows,
                            ctx={
                                "tasks_reports_dir_param_name": "gradle.input.dir",
                                "vcs_url": "https://bitbucket.browser.yandex-team.ru/scm/ml/mobile-alice-library-android.git",
                                "pass_logs_to_teamcity": False,
                                "delegate_emulator_launch": False,
                                "build_target": ["bricks:assembleAndroidTest",
                                                 "messenger:systemtest:assembleAndroidTest"],
                                "optimization_group": None,
                                "use_latest_revision": False,
                                "vcs_group": None,
                                "tests_resource": None,
                                "system_gradle_parameters": {},
                                "dont_need_root": False,
                                "secret_gradle_parameters": {},
                                "ssh_key": "MSSNGR:mssngr-r-rel__ssh_key",
                                "use_new_git_helper": False,
                                "build_agent_parameters_group": None,
                                "pass_reports_to_teamcity": False,
                                "advanced_devices_config": ["API28_480_1080x1920_default"],
                                "need_git_lfs": False,
                                "report_target": [],
                                "retry_count": 0,
                                "output_dir_param_name": "sandbox.outputDir",
                                "aggregated_reports": {"Aggregated Report": "aggregated_allure_report/index.html"},
                                "aggregated_report_parameters": None,
                                "report_duration": 10,
                                "teamcity_group": None,
                                "use_ssd": False,
                                "time_to_kill": 10800,
                                "launch_xvfb": True,
                                "gradle_group": None,
                                "test_parameters_group": None,
                                "other_parameters_group": None,
                                "teamcity_artifact_paths": {},
                                "run_target": ["bricks:spoonDebugAndroidTest",
                                               "messenger:systemtest:spoonReleaseAndroidTest"],
                                "multislot_type": "2",
                                "gradle_log_level": "--info",
                                "branch": "dev",
                                "gradle_parameters": {"testBuildType": "release", "android.enableR8": "False",
                                                      "android.useProguard": "False"},
                                "platform_specific_parameters_group": None,
                                "aggregated_reports_dir_param_name": "gradle.output.dir",
                                "api_levels": [
                                    "17_google_apis",
                                    "19_google_apis",
                                    "22_google_apis",
                                    "22_default",
                                    "23_google_apis",
                                    "23_default",
                                    "24_google_apis",
                                    "24_default",
                                    "25_google_apis",
                                    "25_default",
                                    "26_google_apis",
                                    "26_default",
                                    "27_google_apis",
                                    "27_default",
                                    "28_google_apis",
                                    "28_default",
                                ],
                                "execute_if_failed": True,
                                "reports": {
                                    "Bricks": "bricks/debug/index.html",
                                    "Systemtest": "systemtest/release/index.html",
                                },
                                "use_tmpfs": False,
                                "container_version": "stable",
                            }
                        )
                    )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [
                    rm_const.ReleaseStatus.testing,
                    rm_const.ReleaseStatus.prestable,
                    rm_const.ReleaseStatus.stable,
                ]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="REGISTRY",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="registry",
                                            resource_name="MSSNGR_REGISTRY",
                                        ),
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="registry_contacts_indexer",
                                            resource_name="MSSNGR_CONTACTS_INDEXER",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="REGISTRY_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="registry_config_prod",
                                            resource_name="MSSNGR_REGISTRY_CONFIG",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="YAMB_CODE_BUNDLE",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="registry_yamb_code_bundle",
                                            resource_name="MSSNGR_YAMB_CODE_BUNDLE",
                                        ),
                                    ),
                                ),
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_REGISTRY_{}".format(release_stage.upper()),
                                ) if release_stage != rm_const.ReleaseStatus.stable else None,
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_REGISTRY_INTERNAL_{}".format(release_stage.upper()),
                                ) if release_stage == rm_const.ReleaseStatus.prestable else None,
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="LAUNCH_{}_ANDROID_TESTS".format(release_stage.upper()),
                                ) if release_stage != rm_const.ReleaseStatus.stable else None,
                            ),
                        )
                    )
                return release_part

        class JobPatch(cfg.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                rm_job_name = rm_const.JobTypes.rm_job_name
                build = rm_const.JobTypes.BUILD
                tests.update({
                    rm_job_name(build, self.name, "REGISTRY"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "REGISTRY_CONFIG"): rm_const.TestFrequencies.EACH_REV_TEST,
                    rm_job_name(build, self.name, "YAMB_CODE_BUNDLE"): rm_const.TestFrequencies.EACH_REV_TEST,

                })
                return tests

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Mail(cfg.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["mssngr-ops"]

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "manokk"
            queue = "MSSNGROPS"
            dev_queue = "MSSNGRBACKEND"
            summary_template = u"Приемка Registry: {}"

            followers = [
                "thorfinn",
                "chmerev",
                "manokk",
            ]

            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branch_name = "mssngr/registry"

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "messenger/releases/registry"
        dirs = [
            "arcadia/mssngr/router/daemons/registry",
            "arcadia/mssngr/router/lib",
            "arcadia/mssngr/router/conf"
        ]

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 24 * 60 * 60

        resources_info = [
            cfg.ReleasedResourceInfo(
                name="registry",  # Arbitrary identifier of release item
                resource_type="MSSNGR_REGISTRY",  # Resource type
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_registry_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_registry_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_registry_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_contacts_indexer",  # Arbitrary identifier of release item
                resource_type="MSSNGR_CONTACTS_INDEXER",  # Resource type
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_registry_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_registry_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_registry_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_yamb_code_bundle",  # Arbitrary identifier of release item
                resource_type="MSSNGR_YAMB_CODE_BUNDLE",  # Resource type
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_registry_man"),
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_registry_man"),
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_registry_man")
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_loop_conf_prod",
                resource_type="MSSNGR_REGISTRY_LOOP_CONF",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="registry_loop_conf_alpha",
                resource_type="MSSNGR_REGISTRY_ALPHA_LOOP_CONF",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="registry_internal_loop_conf_alpha",
                resource_type="MSSNGR_REGISTRY_INTERNAL_ALPHA_LOOP_CONF",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="registry_internal_loop_conf_prod",
                resource_type="MSSNGR_REGISTRY_INTERNAL_LOOP_CONF",
                build_ctx_key="arcadia_url",

            ),
            cfg.ReleasedResourceInfo(
                name="registry_loop_conf_testing",
                resource_type="MSSNGR_REGISTRY_TESTING_LOOP_CONF",
                build_ctx_key="arcadia_url",
            ),
            cfg.ReleasedResourceInfo(
                name="registry_config_prod",
                resource_type="MSSNGR_REGISTRY_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_registry_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_internal_config_prod",
                resource_type="MSSNGR_REGISTRY_INTERNAL_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "production_mssngr_registry_internal_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_config_testing",
                resource_type="MSSNGR_REGISTRY_TESTING_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.testing, "testing_mssngr_registry_man")

                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_config_alpha",
                resource_type="MSSNGR_REGISTRY_ALPHA_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_registry_man"),
                ]
            ),
            cfg.ReleasedResourceInfo(
                name="registry_internal_config_alpha",
                resource_type="MSSNGR_REGISTRY_INTERNAL_ALPHA_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=[
                    (rm_const.ReleaseStatus.prestable, "alpha_mssngr_registry_internal_man"),
                ]
            ),
        ]
