# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs


class MusicCfg(configs.ReferenceBranchedConfig):
    name = "music"
    responsible = "paulus"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "MUSIC"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = []

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["Music Backend"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "paulus"
            queue = "RMTEST"
            dev_queue = "RMDEV"
            summary_template = u"Релиз бэкендов Музыки {}"
            workflow = {}
            followers = [
                "paulus",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/KachestvoPoiska/releasemachinetestcomponent/releases/"
        wiki_page_owner = "robot-music-backend"
        dirs = [
            "arcadia/music",
        ]
        review_groups = [
            "music",
        ]
