# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const

from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg

import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data


RESOURCES = [
    "HORIZON_AGENT_CONFIG_MUSIC",
    "APP_HOST_STABLE_BRANCH_MUSIC",
]


class MusicGraphsCfg(configs.ReferenceBranchedConfig):
    name = "music_graphs"
    responsible = "epinkovskii"
    component_group = "reference_component_metricsed"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "MUSIC"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "MUSIC",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="acceptance",
                        job_params={
                            "job_name_parameter": "BETA",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "app_host_stable_branch",
                                        "APP_HOST_STABLE_BRANCH_MUSIC",
                                    ),
                                ),
                            ),
                        ),
                    ),
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_name_parameter="LAUNCH_METRICS_MUSIC",
                        search_subtype="music",
                        ctx={
                            "autoclicker_retry_count": 3,
                            "sample_beta": "music-hamster.music-web.music.qable",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda beta_name, params: "{}.music-web.music.qable".format(beta_name)
                                    ),
                                ),
                                job_name_parameter="BETA",
                            ),
                        ),
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                    ),
                )

                return branch_part

    class Releases(configs.ReferenceBranchedConfig.Releases):

        release_followers_permanent = [
            "epinkovskii",
        ]
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.NannyDeployInfo(services=self._all_services),
                    ],
                ) for resource in RESOURCES
            ]

        @property
        def _production_services(self):
            return [
                ri.DeployService("production_app_host_{loc}_music".format(loc=loc))
                for loc in rm_const.MAIN_LOCATIONS
            ]

        @property
        def _hamster_services(self):
            return [
                ri.DeployService('hamster_app_host_{loc}_music'.format(loc=loc))
                for loc in ['man', 'vla']
            ]

        @property
        def _all_services(self):
            return self._production_services + self._hamster_services

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/music"
        tag_name = "apphost/conf/music"

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            queue = "MEDIASEARCH"
            summary_template = u"Приемка графов MUSIC {}"
            followers = [
                "epinkovskii",
            ]
            assignee = "epinkovskii"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "music/apphost/changelog/"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/MUSIC",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "acceptance": yappy_cfg.YappyTemplateCfg(
                template_name="music-apphost-graphs",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="music-apphost-graphs",
                        resources=[
                            yappy_cfg.YappyParametrizedResource("app_host_stable_branch", "stable_branch"),
                        ],
                        parent_service="hamster_app_host_man_music",
                    ),
                ],
                new_yappy=True,
            ),
        }
