# -*- coding: utf-8 -*-

from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri


class MyAliceCfg(configs.ReferenceBranchedConfig):
    name = "my_alice_backend"
    display_name = "Alisa PASkills My Alice backend"
    responsible = configs.Responsible(
        abc=configs.Abc(component_id=1886),
        login="pazus",
    )

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "PASKILLS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        resource_names="MY_ALICE_BACKEND_BINARY",
                        package_names="alice/paskills/my_alice/pkg.json",
                        job_params={
                            "apiargs": {
                                'kill_timeout': 2700,
                            },
                        },
                        ctx={
                            'package_type': 'docker',
                            'build_type': "release",
                            'docker_push_image': True,
                            'docker_registry': 'registry.yandex.net',
                            'docker_image_repository': 'paskills',
                            'docker_user': 'robot-paskills-ci',
                            'docker_token_vault_name': 'robot-paskills-ci-docker-registry-token',
                            'docker_build_network': 'host',
                            'checkout': False,
                            common_const.YA_YT_STORE: True,
                            common_const.IGNORE_RECURSES: True,
                            common_const.BUILD_SYSTEM_KEY: common_const.SEMI_DISTBUILD_BUILD_SYSTEM
                        },
                        out={"MY_ALICE_BACKEND_BINARY": 20},
                    )
                )

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="MY_ALICE_BACKEND_BINARY",
                                            resource_name="MY_ALICE_BACKEND_BINARY",
                                        )
                                    )
                                )
                            ),
                            job_params={
                                "observed_paths": [
                                    'alice/paskills/my_alice',
                                ],
                            },
                        )
                    )
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                    ))
                release_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranched(
                        job_arrows=(
                            jg_job_triggers.JobTriggerChangelogFinal(),
                            jg_job_triggers.JobTriggerNewTag(),
                        )
                    )
                )
                return release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["dialogovo-releases"]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """

            assignee = "pazus"
            queue = "ALICERELEASE"
            dev_queue = "PASKILLS"
            summary_template = u"Релиз Alisa PASkills My Alica Backend {}"

            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                assignee,
                "kuptservol"
                "pazus",
                "ivangromov",
                "stackoverflow",
            ]
            add_commiters_as_followers = True
            hide_commits_under_cut = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        use_arc = True
        branch_name = "paskills/my_alice_backend"
        tag_name = "paskills/my_alice_backend"
        arc_tag_folder = "tags/releases/alice/paskills"
        arc_branches_folder = "releases/alice/paskills"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """

        dirs = ["arcadia/alice/paskills/my_alice"]
        wiki_page = ""

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="MY_ALICE_BACKEND_BINARY",
                    data=ri.SandboxResourceData("MY_ALICE_BACKEND_BINARY"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            ri.DeployService("my_alice_{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                        ),
                        ri.NannyDeployInfo(
                            [ri.DeployService("my_alice_testing")],
                            stage=rm_const.ReleaseStatus.testing,
                        ),
                    ]
                )
            ]

        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 5 * 60  # 10 min
