# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.helpers.arcadia as rm_arc
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class OntodbCfg(configs.ReferenceBranchedConfig):
    name = "ontodb"
    responsible = "alzobnin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "ontodb-trunk"
        trunk_task_owner = "ENTITYSEARCH"
        branch_db_template = "ontodb-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_PACKAGE",
                        build_item="PACKAGE",
                        job_params={
                            "apiargs": {
                                "kill_timeout": 10800,
                            },
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: rm_arc.construct_arc_url(
                                    arc_url="arcadia:/arc/{}".format(x.svn_path),
                                    arc_rev=x.revision,
                                ),
                                override=True,
                            )
                        ),
                        ctx={
                            "packages": "dict/ontodb/ontopkg.json",
                            "package_type": "tarball",
                            "checkout": False,
                            sandbox_constants.BUILD_TYPE_KEY: "release",
                            sandbox_constants.CLEAR_BUILD_KEY: False,
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.SEMI_DISTBUILD_BUILD_SYSTEM,
                            sandbox_constants.FORCE_VCS_INFO_UPDATE: True,
                            "ya_yt_store": False,
                            "ignore_recurses": False,
                            "resource_type": "YA_PACKAGE",
                        },
                        out={"YA_PACKAGE": 90},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="MAKE_BUILD_ONTODB_EXECUTABLE",
                        build_item="EXECUTABLE",
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: rm_arc.construct_arc_url(
                                    arc_url="arcadia:/arc/{}".format(x.svn_path),
                                    arc_rev=x.revision,
                                ),
                                override=True,
                            )
                        ),
                        out={"BUILD_ONTODB_EXECUTABLE": 90},
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="PACKAGE",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="EXECUTABLE",
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                ]
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests_frequencies = super(self.__class__, self).change_frequency
                tests_frequencies["_BUILD_ONTODB_PACKAGE"] = rm_const.TestFrequencies.EACH_REV_TEST
                tests_frequencies["_MAKE_BUILD_ONTODB_EXECUTABLE"] = rm_const.TestFrequencies.EACH_REV_TEST
                return tests_frequencies

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_prefix = "0"
        tag_prefix = branch_prefix

        branch_folder_template = "{branch_prefix}.{branch_num}"
        branch_folder_pattern = r"0\.([0-9]+)"
        tag_folder_template = "{tag_prefix}.{branch_num}-{tag_num}"
        tag_folder_pattern = r"0\.([0-9]+)-([0-9]+)"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        resources_info = []

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["entitysearch_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/joinchat/AMbWjBKAB3e_NZhlyBuNTQ"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "robot-ontodb"
            queue = "ENTITYREL"
            dev_queue = "SEARCH"
            summary_template = u"Main-база объектного ответа v0.{}"
            components = "backend"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = []
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/EntitySearch/ontodb/releases/"
        dirs = [
            "arcadia/dict/ontodb",
        ]
        review_groups = [
            "entitysearch",
            "ontodb",
        ]
