# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_PCODE",
    "APP_HOST_STABLE_BRANCH_PCODE",
]


class PcodeGraphsCfg(configs.ReferenceBranchedConfig):
    name = "pcode_graphs"
    responsible = configs.Responsible(abc=configs.Abc(component_id=31282), login="evor")

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "PCODE"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "PCODE",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.single_nanny_service("production_app_host_myt_pcode"),
                        ri.single_nanny_service("testing_app_host_myt_pcode", rm_const.ReleaseStatus.testing),
                    ],
                )
                for resource in RESOURCES
            ]
        release_followers_permanent = []
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/pcode"
        tag_name = "apphost/conf/pcode"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "volcolac"
            queue = "PCODE"
            summary_template = u"Приемка графов PCODE {}"
            followers = [
                "evor",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "pcode/apphost-graphs/changelog/"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/PCODE",
        ]
