# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class PersonalCardsCfg(configs.ReferenceCIConfig):
    name = "personal_cards"
    display_name = "Alice.PersonalCards"
    responsible = configs.Responsible(
        # https://abc.yandex-team.ru/services/yandexassistantcards/?scopeid=1
        abc=configs.Abc(service_name="yandexassistantcards", role_id=1),
        login="chegoryu",
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "alice/personal_cards"
        secret = "sec-01fwyenwrjgcfa2m424t3dvg2b"
        sb_owner_group = "BASS"

        ya_make_abs_paths_glob = [
            "alice/personal_cards/**",
        ]

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/personal_cards/build_personal_cards"

        def _get_build_cube(self, graph):
            build = build_cubes.YaMakeTemplate(
                # Hack to avoid target_resources override
                target_resources=None,
                name="build",
                task=self.build_task,
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )
            build.input.update(thinlto=True)
            return build

    class Releases(configs.ReferenceCIConfig.Releases):
        release_followers_permanent = [
            "chegoryu",
            "elshiko",
        ]
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.nanny_push

        @property
        def releasable_items(self):
            production_deploy_infos = [
                ri.NannyPushDeployInfo(
                    [
                        ri.DeployService("personal_cards_{}".format(loc)) for loc in rm_const.MAIN_LOCATIONS
                    ] + [
                        ri.DeployService("personal_cards_prestable"),
                    ],
                    stage=rm_const.ReleaseStatus.stable,
                ),
            ]
            testing_deploy_infos = [
                ri.NannyPushDeployInfo(
                    [
                        ri.DeployService("personal_cards_testing"),
                    ],
                    stage=rm_const.ReleaseStatus.testing,
                ),
            ]
            all_deploy_infos = production_deploy_infos + testing_deploy_infos
            return [
                ri.ReleasableItem(
                    name="personal_cards_binary",
                    data=ri.SandboxResourceData("PERSONAL_CARDS_BINARY", dst_path="personal_cards"),
                    deploy_infos=all_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="personal_cards_instancectl_config",
                    data=ri.SandboxResourceData("PERSONAL_CARDS_INSTANCECTL_CONFIG", dst_path="instancectl.conf"),
                    deploy_infos=all_deploy_infos,
                ),

                ri.ReleasableItem(
                    name="personal_cards_config_production",
                    data=ri.SandboxResourceData("PERSONAL_CARDS_CONFIG_PRODUCTION", dst_path="config.json"),
                    deploy_infos=production_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="personal_cards_config_testing",
                    data=ri.SandboxResourceData("PERSONAL_CARDS_CONFIG_TESTING", dst_path="config.json"),
                    deploy_infos=testing_deploy_infos,
                ),

                ri.ReleasableItem(
                    name="personal_cards_tvm_config_production",
                    data=ri.SandboxResourceData("PERSONAL_CARDS_TVM_CONFIG_PRODUCTION", dst_path="tvm_config.json"),
                    deploy_infos=production_deploy_infos,
                ),
                ri.ReleasableItem(
                    name="personal_cards_tvm_config_testing",
                    data=ri.SandboxResourceData("PERSONAL_CARDS_TVM_CONFIG_TESTING", dst_path="tvm_config.json"),
                    deploy_infos=testing_deploy_infos,
                ),
            ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "chegoryu"
            queue = "PERSONALCARDSRE"
            dev_queue = "PERSONALCARDS"
            summary_template = u"Приемка personal_cards {}"
            workflow = {}
            followers = [
                "chegoryu",
                "elshiko",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "personal_cards/releases/"
        observed_paths = [
            "arcadia/alice/personal_cards",
        ]

        use_previous_branch_as_baseline = True

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 19  # moved to the CI since the 18th branch
