# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.plus.rm as rm_conf
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class PlusLandingBackendCfg(cfg.ReferenceBranchedConfig):

    name = "plus_landing_backend"
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=36059, schedule_slug="duty"), login="krabishe")
    component_group = rm_conf.COMPONENT_GROUP

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        """
        TestEnv configuration settings
        """
        trunk_task_owner = rm_conf.TRUNK_TASK_OWNER
        testenv_db_owners = rm_conf.RM_TESTENV_OWNERS

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(use_arc=self._use_arc)
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name=rm_conf.TASK_NAMES["build"],
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=[
                                    jg_job_data.ParentDataOutput(
                                        input_key="arc_svn_url",
                                        output_key=common_const.ARCADIA_URL_KEY,
                                    ),
                                ],
                            ),
                            jg_arrows.ParamsData("number", jg_utils.get_major_release_number),
                        ),
                        job_params={
                            "apiargs": {
                                "kill_timeout": 120,
                            },
                        },
                        ctx={
                            "package_path": "plus/landing_backend/docker/pkg.json",
                            "release": True,
                            "component_name": self.name,
                        },
                        out={rm_conf.RELEASE_RESOURCE: 20},
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part_default = super(self.__class__, self)._release
                release_part = []
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_params={
                                "task_name": rm_conf.TASK_NAMES["release2"],
                                "restart_policy": rm_conf.RESTART_POLICY,
                                "ctx": {
                                    "kill_timeout": 300,
                                    "component_name": self.name,
                                    "flow": release_stage,
                                    "target_state": "DEPLOYED",
                                },
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            rm_conf.RELEASE_RESOURCE,
                                            rm_conf.RELEASE_RESOURCE,
                                        ),
                                        jg_job_data.ParentDataOutput(
                                            input_key="version",
                                            output_key="tag",
                                        )
                                    ),
                                )
                            )
                        )
                    )
                release_part.extend([
                    jg_release.JobGraphElementActionReleaseBranched(release_to=rm_const.ReleaseStatus.stable),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.testing,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        }
                    ),
                ])
                return release_part_default + release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        """ Notification settings """

        class Telegram(cfg.ReferenceBranchedConfig.Notify.Telegram):
            """ Telegram notifications """
            chats = ["mir-releases"]
            invite_link = "https://t.me/joinchat/AoGM6x0jo4CBCpnfIxOgyQ"

        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            """
            Startrek notifications

            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """
            assignee = "kgerasimovhtc"
            queue = rm_conf.STARTREK_QUEUE
            followers = rm_conf.STARTREK_FOLLOWERS
            summary_template = "Plus Landing Backend {}"
            add_commiters_as_followers = True
            followers = ["kireevroman", "krabishe"]
            ticket_type = u"Релиз"
            use_task_author_as_assignee = False
            hide_commits_under_cut = True
            nanny_reports = False
            deadline = 7
            important_changes_limit = rm_conf.IMPORTANT_CHANGES_LIMIT

            @property
            def tags(self):
                return ["rm_main_ticket", self.name, "component_name_{}".format(self.name)]

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        """
        Changelog configuration

        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """
        dirs = [
            "arcadia/plus/landing_backend",
            "arcadia/plus/utils"
        ]
        wiki_page = ""

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        use_arc = True
        branch_name = "plus/landing_backend"
        tag_name = "plus/landing_backend"
        tag_folder_template = "{branch_num}.{tag_num}"
        allow_autobranches = False

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.sandbox

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=rm_conf.RELEASE_RESOURCE,
                    data=ri.SandboxResourceData(rm_conf.RELEASE_RESOURCE, build_ctx_key="arc_svn_url",
                                                attributes={"component_name": self.name}),
                    deploy_infos=[
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
            ]
