# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs as cfg
import sandbox.projects.plus.rm as rm_conf
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import internal as internal_cubes
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow


class PlusRaBackendCfg(cfg.ReferenceCIConfig):

    name = "plus_plusometer_backend"
    display_name = "Plus Plusometer Backend"
    responsible = cfg.Responsible(abc=cfg.Abc(component_id=38937, role_id=1), login="krabishe")
    component_group = rm_conf.COMPONENT_GROUP
    robot = "robot-mi-deploy"

    class CI(cfg.ReferenceCIConfig.CI):
        secret = "sec-01ek03c43b3r71me6n48e8n35f"
        sb_owner_group = rm_conf.TRUNK_TASK_OWNER
        a_yaml_dir = "plus/plusometer/docker"
        ya_make_abs_paths_glob = [
            "plus/plusometer/**",
        ]
        grant_config_update_permissions_to_release_machine_robot = False

    class JG(basic_build_presets.SingleBuildGeneralJGCfg):

        @jg_flow.release_flow(stages=basic_build_presets.DEFAULT_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(PlusRaBackendCfg.JG, self).release(self)
            release_entry = graph.get("release_stage_entry")
            release_stable = graph.get("release_stable_sandbox")
            release_prestable = graph.get("release_prestable_sandbox")
            release_testing = graph.get("release_testing_sandbox")

            release_testing.add_requirement(release_entry)
            release_prestable.add_requirement(release_testing)
            release_stable.add_requirement(release_prestable)
            return graph

        @property
        def release_task(self):
            return rm_conf.TASK_CI_REG_LOCATIONS["release2"]

        @property
        def build_task(self):
            return rm_conf.TASK_CI_REG_LOCATIONS["build"]

        def _get_build_cube(self, graph):
            return build_cubes.AfishaBuildDocker(
                component_name=self.component_name,
                package_path=self.root_cfg.releases_cfg.releasable_items[0].build_data.target,
                needs=[graph.get("main_graph_entry"), graph.get(internal_cubes.CreateStartrekTicket.NAME)],
                input=jg_cube.CubeInput(
                    arc_svn_url="${tasks.new_tag.svn_data.svn_paths.tag}/arcadia",
                    checkout_arcadia_from_url="${tasks.new_tag.svn_data.svn_paths.tag}/arcadia",
                ),
            )

        def _get_release_cubes(self, graph, build):
            result = []

            for deploy_system, where, releasable_items in (
                self._iter_over_releasable_items_with_release_stages_and_deploy_systems(build)
            ):
                result.append(
                    release_cubes.AfishaRelease2(
                        name="release_{}_{}".format(where, deploy_system),
                        component_name=self.component_name,
                        where_to_release=where,
                        manual=(True if where in ["stable", "prestable"] else False),
                    )
                )

            return result

    class Notify(cfg.ReferenceCIConfig.Notify):
        """ Notification settings """

        class Telegram(cfg.ReferenceCIConfig.Notify.Telegram):
            """ Telegram notifications """
            chats = ["mir-releases"]
            invite_link = "https://t.me/joinchat/AoGM6x0jo4CBCpnfIxOgyQ"

        class Startrek(cfg.ReferenceCIConfig.Notify.Startrek):
            """
            Startrek notifications
            https://wiki.yandex-team.ru/releasemachine/startrekoptions/
            """
            assignee = "krabishe"
            queue = rm_conf.STARTREK_QUEUE
            followers = rm_conf.STARTREK_FOLLOWERS
            summary_template = "Plus Plusometer Backend {}"
            add_commiters_as_followers = True
            followers = ["krabishe"]
            ticket_type = u"Релиз"
            use_task_author_as_assignee = False
            hide_commits_under_cut = True
            nanny_reports = False
            deadline = 7
            important_changes_limit = rm_conf.IMPORTANT_CHANGES_LIMIT

            @property
            def tags(self):
                return ["rm_main_ticket", self.name, "component_name_{}".format(self.name)]

    class ChangelogCfg(cfg.ReferenceCIConfig.ChangelogCfg):
        """
        Changelog configuration
        https://wiki.yandex-team.ru/releasemachine/changelogs/
        """
        dirs = [
            "arcadia/plus/plusometer"
        ]
        wiki_page = ""

    class SvnCfg(cfg.ReferenceCIConfig.SvnCfg):
        use_arc = True
        use_zipatch_only = False
        branch_name = "plus/plusometer"
        tag_name = "plus/plusometer"
        tag_folder_template = "{branch_num}.{tag_num}"
        allow_autobranches = False
        start_version = 65

    class Releases(cfg.ReferenceCIConfig.Releases):
        """Releases configuration"""
        allow_robots_to_release_stable = True
        deploy_system = rm_const.DeploySystem.sandbox

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=rm_conf.RELEASE_RESOURCE,
                    data=ri.SandboxResourceData(rm_conf.RELEASE_RESOURCE, build_ctx_key="arc_svn_url",
                                                attributes={"component_name": self.name}),
                    build_data=ri.BuildData(
                        target="plus/plusometer/package.json",
                    ),
                    deploy_infos=[
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.stable),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.prestable),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.testing),
                    ]
                ),
            ]
