# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg import (
    base as jg_base, flow as jg_flow, cube as jg_cube
)
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core import release_approvements

ABC_SERVICE = 'keydatadev'
USER_LOGIN = 'ciffiro'
SANDBOX_OWNER_GROUP = 'STATKEY'
PROJECT_SOURCE_DIRECTORY = 'statbox/statkey/agency_rewards/product_matrix_release_machine_dev'
OKLO_BINARY_LINK_PATH = 'projects/statkey/agency_rewards/oklo_binary_link'
CALCULATE_DATA_PATH = 'projects/statkey/agency_rewards/calculate_data'
RUN_DIFF_TOOL = 'projects/statkey/agency_rewards/run_diff_tool'
RM_SEC = "sec-01fxqbbc9r56g3eygf2kxkes98"
NAME_COMPONENT = "product_matrix_deploy"
POOL_NAME = 'bigdata_reserved'
PLACE_COMMENT_SEPARATE_COMMENT = "separate_comment"
UPDATE_MODE_REPLACE = "replace"


class ProductMatrixDeploy(configs.ReferenceCIConfig):
    name = NAME_COMPONENT
    responsible = configs.Responsible(abc=configs.Abc(service_name=ABC_SERVICE), login=USER_LOGIN)
    robot = "robot-statkey"

    class JG(jg_base.BaseReleaseMachineJobGraph):
        @jg_flow.release_flow()
        def release(self):
            graph = super(self.__class__, self).release(self)

            oklo_binary_link_cube = jg_cube.Cube(
                name='get_oklo_binary_link',
                title='Get oklo binary link',
                needs=[graph.get('main_graph_entry')],
                task=OKLO_BINARY_LINK_PATH,
                input=jg_cube.CubeInput()
            )

            production_cube = jg_cube.Cube(
                name='calculate_current_data',
                title='Calculate current data',
                needs=[oklo_binary_link_cube],
                task=CALCULATE_DATA_PATH,
                input=jg_cube.CubeInput(
                    config={
                        'use_candidate_library': False,
                        'binary_link': oklo_binary_link_cube.output.config.oklo_binary_link,
                        'pool': POOL_NAME
                    }
                )
            )

            test_cube = jg_cube.Cube(
                name='calculate_candidate_data',
                title='Calculate candidate data',
                needs=[oklo_binary_link_cube],
                task=CALCULATE_DATA_PATH,
                input=jg_cube.CubeInput(
                    config={
                        'use_candidate_library': True,
                        'binary_link': oklo_binary_link_cube.output.config.oklo_binary_link,
                        'pool': POOL_NAME
                    }
                )
            )

            diff_tool = jg_cube.Cube(
                name='get_difference',
                title='Run diff tool on current and candidate library',
                needs=[production_cube, test_cube],
                task=RUN_DIFF_TOOL,
                input=jg_cube.CubeInput(
                    config={
                        'current_path': production_cube.output.config.rewards_path,
                        'candidate_path': test_cube.output.config.rewards_path,
                    }
                )
            )

            create_st_ticket = graph.get('create_startrek_ticket')

            post_rewards_brief_diff = jg_cube.Cube(
                task="projects/release_machine/post_startrek_comment",
                needs=[create_st_ticket, diff_tool],
                input=jg_cube.CubeInput(
                    issue_key=create_st_ticket.output.st_ticket.key,
                    place_comment=PLACE_COMMENT_SEPARATE_COMMENT,
                    comment_text=diff_tool.output.result.brief_report,
                    update_mode=UPDATE_MODE_REPLACE,
                )
            )

            post_rewards_detiled_diff_link = jg_cube.Cube(
                task="projects/release_machine/post_startrek_comment",
                needs=[create_st_ticket, diff_tool],
                input=jg_cube.CubeInput(
                    issue_key=create_st_ticket.output.st_ticket.key,
                    place_comment=PLACE_COMMENT_SEPARATE_COMMENT,
                    comment_text=diff_tool.output.result.detailed_report_link,
                    update_mode=UPDATE_MODE_REPLACE,
                )
            )

            create_st_ticket.add_requirement(diff_tool)

            cubes = (
                oklo_binary_link_cube,
                production_cube,
                test_cube,
                diff_tool,
                post_rewards_brief_diff,
                post_rewards_detiled_diff_link
            )

            for cube in cubes:
                graph.add(cube)

            return graph

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = PROJECT_SOURCE_DIRECTORY
        secret = RM_SEC
        sb_owner_group = SANDBOX_OWNER_GROUP
        ya_make_abs_paths_glob = [
            PROJECT_SOURCE_DIRECTORY + '/**',
        ]
        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="dummy_releasable_item",
                    data=ri.SandboxResourceData("OTHER_RESOURCE"),
                    deploy_infos=[
                        ri.single_nanny_service("dummy_service"),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True

        approvements = release_approvements.ReleaseApprovementsSettings(
            description="Please approve new Product Matrix version {tag_name}",
            stages=[
                # "maxstatsenko",
                # "nerd",
                # "vbatraev",
                "nkazakowa"
            ],
        )

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = True

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            # TODO: uncomment after test run
            # assignee = "nerd"
            # queue = "GRAD"
            assignee = "nkazakowa"
            queue = "STATKEYAR"
            summary_template = "Релиз Продуктовой Матрицы {}"
            # TODO: uncomment after test run
            followers = [
                # "maxstatsenko",
                # "nerd",
                # "vbatraev",
                # "alexpelin"
                "nkazakowa"
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            tags = ["product_matrix_release"]
            hide_commits_under_cut = True

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            PROJECT_SOURCE_DIRECTORY,
        ]
