# -*- coding: utf-8 -*-
import datetime
import random

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common import constants as sandbox_constants
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class PrsOpsCfg(configs.ReferenceBranchedConfig):
    name = "prs_ops"
    responsible = "i024"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "prs-ops-trunk"
        trunk_task_owner = "SEARCH-RELEASERS"
        branch_db_template = "prs-ops-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            SAVE_TO = "{rand_int}N{time}{{}}".format(
                rand_int=random.randint(0, 9),
                time=datetime.datetime.now().replace(microsecond=0).isoformat(),
            )
            OBSERVED_PATHS = ["quality/query_pool/prs_ops", ]
            IGNORED_PATHS = ["quality/query_pool/prs_ops/prs_downloads_configs", ]

            @property
            def _trunk_part(self):
                default_trunk_part = super(self.__class__, self)._trunk_part
                trunk_part = [
                    jg_test.JobGraphElementTestTrunkCommon(
                        task_name="PRS_OPS_CLEAN_TABLES",
                        job_params={
                            "job_name_parameter": "REMOVE_OLD_TABLES",
                        },
                    )
                ]
                return default_trunk_part + trunk_part

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part

                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_PRS_OPS",
                        build_item="BIG",
                        job_params={
                            "observed_paths": self.OBSERVED_PATHS,
                            "ignored_paths": self.IGNORED_PATHS,
                        },
                        ctx={
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.BUILD_TYPE_KEY: sandbox_constants.RELEASE_BUILD_TYPE,
                        },
                        out={
                            "PRS_OPS_EXECUTABLE": 30,
                            "PROTO_POOL_READER_EXECUTABLE": 30,
                            "POOL_CONVERTER_EXECUTABLE": 30,
                            "PRS_OPS_FACTOR_DIFF": 30,
                        },
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_PRS_OPS",
                        ctx={
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.BUILD_TYPE_KEY: sandbox_constants.RELEASE_BUILD_TYPE,
                        },
                        out={"PRS_OPS_EXECUTABLE": 30},
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RUN_PRS_OPS_NIRVANA",
                        job_params={
                            "job_name_parameter": "RUN_NIRVANA",
                            "observed_paths": self.OBSERVED_PATHS,
                            "ignored_paths": self.IGNORED_PATHS,
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key="nirvana_global_options",
                                triggers=(
                                    jg_job_triggers.JobTriggerBuild(
                                        job_name_parameter="BIG",
                                        parent_job_data=(
                                            jg_job_data.ParentDataResource(
                                                input_key="current_res_id",
                                                resource_name="PRS_OPS_EXECUTABLE",
                                            ),
                                        ),
                                    ),
                                    jg_arrows.GlobalResourceData(
                                        input_key="queries_res_id",
                                        resource_name="PRS_OPS_QUERIES_FULL_BIG",
                                    ),
                                    jg_arrows.GlobalResourceData(
                                        input_key="ratings_res_id",
                                        resource_name="PRS_OPS_RATINGS_BIG",
                                    ),
                                ),
                                transform=lambda current_res_id, queries_res_id, ratings_res_id: {
                                    "current-prs-ops-resource-id": current_res_id,
                                    "mr-account": "prs_ops",
                                    "yt-token": "yt_prs_ops_token",
                                    "queries-resource-id": queries_res_id,
                                    "ratings-resource-id": ratings_res_id,
                                    "prs-timestamp": datetime.datetime.now().strftime("%d.%m.%Y %H:%M:%S")
                                }
                            )
                        ),
                        ctx={
                            "nirvana_workflow_name": "saylars_test_{}".format(random.randint(0, 9999)),
                            "nirvana_token": "prs_ops_nirvana_test",
                            "nirvana_quota": "web-ranking-prs-ops",
                            "nirvana_workflow_id": "bebfe394-5908-4273-8d13-8076fa8bf4a8",
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RUN_PRS_OPS_CASTING",
                        job_params={
                            "job_name_parameter": "RUN_CASTING",
                            "observed_paths": self.OBSERVED_PATHS,
                            "ignored_paths": self.IGNORED_PATHS,
                            "test_type": jg_utils.TestType.DIFF_TEST,
                            "compare_task_name": "COMPARE_YT_TABLES_PRS_OPS",
                            "diff_resource_type": {"PRS_OPS_DIFF": 30},
                            "has_diff": lambda ctx: ctx.get("has_diff"),
                            "compare_job_triggers": {
                                jg_arrows.CompareTaskDataCtx(
                                    input_key="path_1",
                                    output_key="save_to",
                                    task_number=1,
                                ),
                                jg_arrows.CompareTaskDataCtx(
                                    input_key="path_2",
                                    output_key="save_to",
                                    task_number=2,
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BIG",
                                    parent_job_data=(
                                        jg_job_data.CompareParentDataResource(
                                            input_key="check_diff",
                                            resource_name="PRS_OPS_FACTOR_DIFF",
                                            task_number=2,
                                        ),
                                    ),
                                ),
                            }
                        },
                        job_arrows=(
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_queries_resource",
                                resource_name="PRS_OPS_QUERIES_FULL",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="mapreduce",
                                resource_name="MAPREDUCE_YT_EXECUTABLE",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="prs_ops_binary_resource",
                                        resource_name="PRS_OPS_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="reader",
                                        resource_name="PROTO_POOL_READER_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="converter",
                                        resource_name="POOL_CONVERTER_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "save_to": self.SAVE_TO.format("casting"),
                            "args": "-v",
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RUN_PRS_OPS_CHECK_FILES",
                        job_params={
                            "job_name_parameter": "RUN_CHECK_FILES",
                            "observed_paths": self.OBSERVED_PATHS,
                            "ignored_paths": self.IGNORED_PATHS,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="prs_ops_binary_resource",
                                        resource_name="PRS_OPS_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="reader",
                                        resource_name="PROTO_POOL_READER_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="converter",
                                        resource_name="POOL_CONVERTER_EXECUTABLE",
                                    ),
                                ),
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="mapreduce",
                                resource_name="MAPREDUCE_YT_EXECUTABLE",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_queries_resource",
                                resource_name="PRS_OPS_QUERIES_FULL",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_ratings_resource",
                                resource_name="PRS_OPS_RATINGS",
                            ),
                        )
                    ),
                    # jg_test.JobGraphElementTestBranchCommon(
                    #     task_name="YA_MAKE",
                    #     job_params={
                    #         "job_name_parameter": "UNITTEST",
                    #         "observed_paths": self.OBSERVED_PATHS,
                    #         "ignored_paths": self.IGNORED_PATHS,
                    #     },
                    #     job_arrows=(
                    #         jg_job_triggers.JobTriggerBuild(
                    #             job_name_parameter="BIG",
                    #             parent_job_data=(
                    #                 jg_job_data.ParentDataCtx(
                    #                     input_key=sandbox_constants.ARCADIA_URL_KEY,
                    #                     output_key=sandbox_constants.ARCADIA_URL_KEY,
                    #                 ),
                    #             ),
                    #         ),
                    #     ),
                    #     ctx={
                    #         "targets": "quality/query_pool/prs_ops/tests",
                    #         "test": True,
                    #         "checkout_mode": "auto",
                    #         sandbox_constants.BUILD_TYPE_KEY: sandbox_constants.RELEASE_BUILD_TYPE,
                    #     }
                    # ),
                ]
                FACTOR_DIFF_CTX = {
                    "args": "--gather-features l2 --max-unanswers-count 0 --wizard-success-threshold 0.995 --only-full-answers --stats --do-begemot-validation -v ",
                    "selected_slices": "web_production",
                    "customCGI": "&rearr=no_webfresh_on_middle&pron=nogarbage&rearr=no_webfresh_on_middle&pron=l2_trash=1&pron=basesearch_count=1",
                }
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PRS_OPS_FACTOR_DIFF",
                        job_params={
                            "job_name_parameter": "RUN_FACTOR_DIFF",
                            "observed_paths": self.OBSERVED_PATHS,
                            "ignored_paths": self.IGNORED_PATHS,
                            "test_type": jg_utils.TestType.DIFF_TEST,
                            "compare_task_name": "COMPARE_YT_TABLES_PRS_OPS",
                            "diff_resource_type": {"PRS_OPS_DIFF": 30},
                            "has_diff": lambda ctx: ctx.get("has_diff"),
                            "compare_job_triggers": {
                                jg_arrows.CompareTaskDataCtx(
                                    input_key="path_1",
                                    output_key="save_to",
                                    task_number=1,
                                ),
                                jg_arrows.CompareTaskDataCtx(
                                    input_key="path_2",
                                    output_key="save_to",
                                    task_number=2,
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BIG",
                                    parent_job_data=(
                                        jg_job_data.CompareParentDataResource(
                                            input_key="check_diff",
                                            resource_name="PRS_OPS_FACTOR_DIFF",
                                            task_number=2,
                                        ),
                                    ),
                                ),
                            }
                        },
                        job_arrows=(
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_queries_resource",
                                resource_name="PRS_OPS_QUERIES_FULL",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_ratings_resource",
                                resource_name="PRS_OPS_RATINGS",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="mapreduce",
                                resource_name="MAPREDUCE_YT_EXECUTABLE",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="prs_ops_binary_resource",
                                        resource_name="PRS_OPS_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="reader",
                                        resource_name="PROTO_POOL_READER_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="converter",
                                        resource_name="POOL_CONVERTER_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="check_diff",
                                        resource_name="PRS_OPS_FACTOR_DIFF",
                                    ),
                                ),
                            ),
                        ),
                        ctx=jg_utils.union_dicts(
                            {"save_to": self.SAVE_TO.format("factor_diff")},
                            FACTOR_DIFF_CTX,
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PRS_OPS_FACTOR_DIFF",
                        job_params={
                            "job_name_parameter": "RUN_FACTOR_DIFF_BIG",
                            "observed_paths": self.OBSERVED_PATHS,
                            "ignored_paths": self.IGNORED_PATHS,
                            "test_type": jg_utils.TestType.DIFF_TEST,
                            "compare_task_name": "COMPARE_YT_TABLES_PRS_OPS",
                            "diff_resource_type": {"PRS_OPS_DIFF": 30},
                            "has_diff": lambda ctx: ctx.get("has_diff"),
                            "compare_job_triggers": {
                                jg_arrows.CompareTaskDataCtx(
                                    input_key="path_1",
                                    output_key="save_to",
                                    task_number=1,
                                ),
                                jg_arrows.CompareTaskDataCtx(
                                    input_key="path_2",
                                    output_key="save_to",
                                    task_number=2,
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BIG",
                                    parent_job_data=(
                                        jg_job_data.CompareParentDataResource(
                                            input_key="check_diff",
                                            resource_name="PRS_OPS_FACTOR_DIFF",
                                            task_number=2,
                                        ),
                                    ),
                                ),
                            }
                        },
                        job_arrows=(
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_queries_resource",
                                resource_name="PRS_OPS_QUERIES_FULL_BIG",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="prs_ops_ratings_resource",
                                resource_name="PRS_OPS_RATINGS_BIG",
                            ),
                            jg_arrows.GlobalResourceData(
                                input_key="mapreduce",
                                resource_name="MAPREDUCE_YT_EXECUTABLE",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="prs_ops_binary_resource",
                                        resource_name="PRS_OPS_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="reader",
                                        resource_name="PROTO_POOL_READER_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="converter",
                                        resource_name="POOL_CONVERTER_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="check_diff",
                                        resource_name="PRS_OPS_FACTOR_DIFF",
                                    ),
                                ),
                            ),
                        ),
                        ctx=jg_utils.union_dicts(
                            {"save_to": self.SAVE_TO.format("factor_diff_big")},
                            FACTOR_DIFF_CTX,
                        ),
                    )
                )
                for build_item, sanitizer in [
                    ("BASE", "none"),
                    ("ASAN", "address"),
                    ("MSAN", "memory"),
                    ("TSAN", "thread"),
                    ("LSAN", "leak"),
                    ("UBSAN", "undefined"),
                ]:
                    if build_item != "BASE":
                        branch_part.append(
                            jg_build.JobGraphElementYaMakeBuildBranched(
                                task_name="BUILD_PRS_OPS",
                                build_item=build_item,
                                ctx={
                                    sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                                    sandbox_constants.BUILD_TYPE_KEY: sandbox_constants.RELEASE_BUILD_TYPE,
                                    sandbox_constants.SANITIZE: sanitizer,
                                },
                                out={
                                    "PRS_OPS_EXECUTABLE": 30,
                                    "PROTO_POOL_READER_EXECUTABLE": 30,
                                    "POOL_CONVERTER_EXECUTABLE": 30,
                                },
                            )
                        )
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="RUN_PRS_OPS",
                            job_params={
                                "job_name_parameter": "RUN_WITHOUT_YT_{}".format(build_item),
                                "observed_paths": self.OBSERVED_PATHS,
                                "ignored_paths": self.IGNORED_PATHS,
                            },
                            job_arrows=(
                                jg_arrows.GlobalResourceData(
                                    input_key="prs_ops_queries_resource",
                                    resource_name="PRS_OPS_QUERIES_FULL",
                                ),
                                jg_arrows.GlobalResourceData(
                                    input_key="prs_ops_ratings_resource",
                                    resource_name="PRS_OPS_RATINGS",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter=build_item if build_item != "BASE" else "BIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataResource(
                                            input_key="prs_ops_binary_resource",
                                            resource_name="PRS_OPS_EXECUTABLE",
                                        ),
                                    ),
                                ),
                            ),
                            ctx={
                                "sanitizer_type": sanitizer,
                                "mr-server": "",
                                "save_to": "",
                                "write_mode": "tsv",
                                "args": "-v",
                            },
                        )
                    )

                for job_name_param, additional_ctx in [
                    (
                        "BASE",
                        {},
                    ),
                    (
                        "L1",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --gather-features l1",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l1"),
                        },
                    ),
                    (
                        "L2_TM",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --gather-features l2",
                            "customCGI": "&rearr=scheme_Local/LingBoost/EnableLightL2=1&pron=text_machine_l2 ",
                            "tm": True,
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l2tm"),
                        }
                    ),
                    (
                        "L2_JUDGED_TM",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --gather-features l2",
                            "customCGI": "&rearr=scheme_Local/LingBoost/EnableLightL2=1&pron=text_machine_l2 ",
                            "tm": True,
                            "judged_urls": True,
                            "plus": True,
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l2judgedtm"),
                        }
                    ),
                    (
                        "L3_TM",
                        {
                            "tm": True,
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3tm"),
                        }
                    ),
                    (
                        "L3_QUICK",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --search-type quick",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3quick"),
                        }
                    ),
                    (
                        "L3_VIDEO",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --app-host-mode --search-type video",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3quick"),
                        }
                    ),
                    (
                        "L3_VIDEOQUICK",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --app-host-mode --search-type videoquick",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3videoquick"),
                        }
                    ),
                    (
                        "L3_IMAGES",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --app-host-mode --search-type images",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3images"),
                        }
                    ),
                    (
                        "L3_IMAGESULTRA",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --app-host-mode --search-type imagesultra",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3imagesultra"),
                        }
                    ),
                    (
                        "L3_IMAGESQUICK",
                        {
                            "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation  --app-host-mode --search-type imagesquick",
                            "write_mode": "mr-proto",
                            "save_to": self.SAVE_TO.format("l3imagesquick"),
                        }
                    ),
                    (
                        "DYNAMIC_TOP_SIZE",
                        {
                            "customCGI": "&rearr=dynamic_top_sizes_factors",
                            "gdtsf": True,
                            "save_to": self.SAVE_TO.format("dynamictopsize"),
                        }
                    )
                ]:
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="RUN_PRS_OPS",
                            job_params={
                                "job_name_parameter": "RUN_{}".format(job_name_param),
                                "observed_paths": self.OBSERVED_PATHS,
                                "ignored_paths": self.IGNORED_PATHS,
                                "test_type": jg_utils.TestType.DIFF_TEST,
                                "compare_task_name": "COMPARE_YT_TABLES_PRS_OPS",
                                "diff_resource_type": {"PRS_OPS_DIFF": 30},
                                "has_diff": lambda ctx: ctx.get("has_diff"),
                                "compare_job_triggers": {
                                    jg_arrows.CompareTaskDataCtx(
                                        input_key="path_1",
                                        output_key="save_to",
                                        task_number=1,
                                    ),
                                    jg_arrows.CompareTaskDataCtx(
                                        input_key="path_2",
                                        output_key="save_to",
                                        task_number=2,
                                    ),
                                    jg_job_triggers.JobTriggerBuild(
                                        job_name_parameter="BIG",
                                        parent_job_data=(
                                            jg_job_data.CompareParentDataResource(
                                                input_key="check_diff",
                                                resource_name="PRS_OPS_FACTOR_DIFF",
                                                task_number=2,
                                            ),
                                        ),
                                    ),
                                }
                            },
                            job_arrows=(
                                jg_arrows.GlobalResourceData(
                                    input_key="prs_ops_queries_resource",
                                    resource_name="PRS_OPS_QUERIES_FULL",
                                ),
                                jg_arrows.GlobalResourceData(
                                    input_key="prs_ops_ratings_resource",
                                    resource_name="PRS_OPS_RATINGS",
                                ),
                                jg_arrows.GlobalResourceData(
                                    input_key="mapreduce",
                                    resource_name="MAPREDUCE_YT_EXECUTABLE",
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataResource(
                                            input_key="prs_ops_binary_resource",
                                            resource_name="PRS_OPS_EXECUTABLE",
                                        ),
                                        jg_job_data.ParentDataResource(
                                            input_key="reader",
                                            resource_name="PROTO_POOL_READER_EXECUTABLE",
                                        ),
                                        jg_job_data.ParentDataResource(
                                            input_key="converter",
                                            resource_name="POOL_CONVERTER_EXECUTABLE",
                                        ),
                                    ),
                                ),
                            ),
                            ctx=jg_utils.union_dicts(
                                {
                                    "save_to": self.SAVE_TO.format("base"),
                                    "args": "--dont-filter-unmatched --only-full-answers --stats -v --do-begemot-validation ",
                                    "selected_slices": "web_production,web_meta",
                                },
                                additional_ctx,
                            ),
                        )
                    )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = []
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "prs_ops_binary",
                                        "PRS_OPS_EXECUTABLE",
                                    )
                                )
                            )
                        ),
                        job_params={
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(1, 1)],
                                weekday_list=[1, 2, 3],
                                seconds_from_last_run_commit=20 * 3600
                            ),
                        },
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                )
                auto_stable_release_job_arrows = [
                    jg_job_triggers.JobTriggerBuild(
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                "component_resources",
                                "prs_ops_binary",
                                "PRS_OPS_EXECUTABLE",
                            ),
                        ),
                    )
                ]
                release_part.append(
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="AUTO",
                        job_arrows=auto_stable_release_job_arrows,
                    )
                )
                release_part.append(
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="AUTO",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                    )
                )
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):

            @property
            def change_frequency(self):
                uppercase_name = self.name.upper()
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_AUTO_STABLE_RELEASE_{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [ri.ReleasableItem(
                name="prs_ops_binary",
                data=ri.SandboxResourceData("PRS_OPS_EXECUTABLE"),
                deploy_infos=[ri.SandboxInfo()]  # means, that release to sandbox == deploy
            )]

        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="prs_ops_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["prs_ops_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "i024"
            queue = "PRSOPSRELEASE"
            dev_queue = "SEARCH"
            summary_template = u"priemka prs_ops {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "i024",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "JandeksPoisk/KachestvoPoiska/prsops/changelogs/"
        dirs = [
            "arcadia/quality/query_pool/prs_ops",
        ]
        review_groups = [
            "i024",
            "mvel",
            "saku",
            "coffeeman"
        ]
