# -*- coding: utf-8 -*-
import itertools

import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
from sandbox.projects.release_machine.components import configs
from sandbox.projects.quasar.platform import Platform
from sandbox.projects.quasar.release_machine_jobs.config import PlatformConfig, BuildConfig
from sandbox.projects.quasar.release_machine_jobs.build_stage import QuasarYaMakeMinusTJob

PLATFORM_CONFIGS = [
    PlatformConfig(rm_const.RMNames.QUASAR_YANDEXSTATION_2, Platform.YANDEXSTATION_2, (
        BuildConfig(use_ya=True, build_type='eng', sign_image=True),
        BuildConfig(use_ya=True, build_type='userdebug', sign_image=True),
        BuildConfig(use_ya=True, build_type='user', sign_image=True, release=True),
    )),
]


class QuasarYandexstation2Cfg(configs.ReferenceBranchedConfig):
    name = rm_const.RMNames.QUASAR_YANDEXSTATION_2
    responsible = 'pupssman'

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """ Notifications configuration """

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                'quasar-dev@yandex-team.ru',
            ]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = 'pupssman'
            queue = 'QUASAR'
            dev_queue = 'QUASAR'
            platform_queue = 'ALICERELEASE'
            summary_template = u'Отведение ветки quasar-yandexstation_2-{}'
            platform_summary_template = u'Релиз платформы {} из ветки quasar-yandexstation_2-{}'
            workflow = {}
            followers = []
            add_commiters_as_followers = False
            hide_commits_under_cut = True
            important_changes_limit = 1000

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = {
            rm_const.ReleaseStatus.testing: True,
            rm_const.ReleaseStatus.stable: False,
        }

        resources_info = list(itertools.chain(*((
            configs.ReleasedResourceInfo(
                name=platform_config.ota_resource,
                resource_type=platform_config.ota_resource,
                attributes=dict(
                    buildtype='user',
                    signed=True,
                ),
            ),
            configs.ReleasedResourceInfo(
                name=platform_config.daemons_resource,
                resource_type='QUASAR_DAEMONS',
                attributes=dict(
                    quasar_platform=platform_config.platform,
                )
            ))
            for platform_config in PLATFORM_CONFIGS
        )))

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ''
        dirs = [
            'arcadia/yandex_io',
            'arcadia/smart_devices/android'
        ]
        review_groups = [
            'yandex_io',
            'quasar-app',
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = 'quasar/yandexstation_2'
        tag_name = 'quasar/yandexstation_2'

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = 'QUASAR'
        quasar_component = 'yandexstation_2'
        trunk_db = 'quasar-{}-trunk'.format(quasar_component)
        branch_db_template = 'quasar-{}'.format(quasar_component) + '-{testenv_db_num}'

        @staticmethod
        def db_drop_range(branch_number):
            # dont drop any branches -- we will have not too many of them anyways
            return []

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                branch_part.append(QuasarYaMakeMinusTJob())

                for platform_config in PLATFORM_CONFIGS:
                    branch_part.extend(platform_config.branch_part)

                return branch_part

            @property
            def _release(self):
                release = super(self.__class__, self)._release

                for platform_config in PLATFORM_CONFIGS:
                    release.extend(platform_config.release_part)

                return release
