# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class BlablacarCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Blablacar'
        NAME = 'rasp_blablacar'

        PROJECT_PACKAGE_PATH = 'travel/rasp/blablacar/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_BLABLACAR_BINARY'

        DEPLOY_APPLICATION = 'blablacar'

        PROJECT_PATHS = ['arcadia/travel/rasp/blablacar']
        WIKI_PAGE = 'raspisanija/releases/blablacar/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз blablacar {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
