# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class BusWizardApiCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Bus Wizard Api'
        NAME = 'rasp_bus_wizard_api'

        RESPONSIBLE = 'monitorius'
        FOLLOWERS = [
            'lorekhov',
            'monitorius',
            'ityrov'
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/route-search-api/docker_image/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_BUS_WIZARD_API_BINARY'

        DEPLOY_APPLICATION = 'bus-wizard-api'

        PROJECT_PATHS = [
            'travel/rasp/route-search-api',
        ]
        WIKI_PAGE = 'raspisanija/releases/wizards/bus'
        ST_QUEUE = 'RASPWIZARDS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз bus-wizard-api {}'
        ST_COMPONENTS = 'rasp-wizards-api-releases'

        RELEASE_AUTO_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.testing,
        ]

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
