# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class ContentAdminCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Travel - Content Admin'
        NAME = 'travel_content_admin'

        PROJECT_PACKAGE_PATH = 'travel/marketing/content/admin/pkg.json'
        APPLICATION_RESOURCE_NAME = 'TRAVEL_MARKETING_CONTENT_ADMIN_BINARY'

        DEPLOY_APPLICATION = 'content-admin'

        PROJECT_PATHS = ['travel/marketing/content/admin']
        WIKI_PAGE = 'raspisanija/releases/content_admin/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз content-admin {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
