# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class ContentBackendCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Travel - Content Backend'
        NAME = 'travel_content_backend'

        PROJECT_PACKAGE_PATH = 'travel/marketing/content/backend/pkg.json'
        APPLICATION_RESOURCE_NAME = 'TRAVEL_MARKETING_CONTENT_BACKEND_BINARY'

        DEPLOY_APPLICATION = 'content-backend'

        PROJECT_PATHS = ['travel/marketing/content/backend']
        WIKI_PAGE = 'raspisanija/releases/content_backend/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз content-backend {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
