# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class CrosslinkCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = u'Rasp Crosslink'
        NAME = 'rasp_crosslink'

        RESPONSIBLE = 'lorekhov'
        FOLLOWERS = [
            'lorekhov',
            'akafist',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/crosslink/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_CROSSLINK_BINARY'

        DEPLOY_PROJECT = 'trains'
        DEPLOY_APPLICATION = 'crosslink'

        PROJECT_PATHS = ['travel/rasp/crosslink']
        WIKI_PAGE = 'raspisanija/releases/crosslink/'
        ST_QUEUE = 'TRAINS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз crosslink {}'
        ST_COMPONENTS = 'crosslink-releases'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
