# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class HttpProxyCacheCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp HTTP Proxy Cache'
        NAME = 'rasp_http_proxy_cache'

        RESPONSIBLE = 'ganintsev'
        FOLLOWERS = [
            'ganintsev',
            'lorekhov',
            'akafist',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/http_proxy_cache/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_HTTP_PROXY_CACHE_BINARY'

        DEPLOY_PROJECT = 'trains'
        DEPLOY_APPLICATION = 'http-proxy-cache'

        PROJECT_PATHS = ['travel/rasp/http_proxy_cache']
        WIKI_PAGE = 'raspisanija/releases/http_proxy_cache/'
        ST_QUEUE = 'TRAINS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз http-proxy-cache {}'
        ST_COMPONENTS = 'http-proxy-cache-releases'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
