# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class InfoCenterCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Info Center'
        NAME = 'rasp_info_center'

        RESPONSIBLE = 'anded'

        PROJECT_PACKAGE_PATH = 'travel/rasp/info_center/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_INFO_CENTER_BINARY'

        DEPLOY_APPLICATION = 'infocenter'

        PROJECT_PATHS = ['travel/rasp/info_center']
        WIKI_PAGE = 'raspisanija/releases/info_center/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз info_center {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
