# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class MordaCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Morda'
        NAME = 'rasp_morda'

        PROJECT_PACKAGE_PATH = 'travel/rasp/morda/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_MORDA_BINARY'

        DEPLOY_APPLICATION = 'old-morda-python'

        PROJECT_PATHS = ['travel/rasp/morda']
        WIKI_PAGE = 'raspisanija/releases/morda/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз old morda {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
