# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class MordaBackendCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = u'Rasp Morda Backend'
        NAME = 'rasp_morda_backend'

        PROJECT_PACKAGE_PATH = 'travel/rasp/morda_backend/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_MORDA_BACKEND_BINARY'

        DEPLOY_APPLICATION = 'morda-backend'

        PROJECT_PATHS = ['travel/rasp/morda_backend']
        WIKI_PAGE = 'raspisanija/releases/morda_backend/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз morda-backend {}'

        TRUNK_AUTO_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.unstable
        ]
