# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class MordaContentCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Morda Content'
        NAME = 'rasp_morda_content'

        PROJECT_PACKAGE_PATH = 'travel/rasp/morda-content/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_MORDA_CONTENT_BINARY'

        DEPLOY_APPLICATION = 'old-morda-python'

        PROJECT_PATHS = ['travel/rasp/morda-content']
        WIKI_PAGE = 'raspisanija/releases/morda-content/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз old morda-content {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
