# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class PathfinderMapsCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Pathfinder Maps'
        NAME = 'rasp_pathfinder_maps'

        FOLLOWERS = [
            'monitorius',
            'vasbur',
            'frangetta',
            'lorekhov',
            'mikhalych',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/pathfinder_maps/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_PATHFINDER_MAPS_BINARY'

        DEPLOY_APPLICATION = 'pathfinder-maps'

        PROJECT_PATHS = ['travel/rasp/pathfinder_maps']
        WIKI_PAGE = 'raspisanija/releases/pathfinder_maps/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз pathfinder-maps {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
