# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class PathfinderProxyCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Pathfinder Proxy'
        NAME = 'rasp_pathfinder_proxy'

        FOLLOWERS = [
            'monitorius',
            'vasbur',
            'frangetta',
            'lorekhov',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/pathfinder_proxy/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_QUEUE_PATHFINDER_PROXY_BINARY'

        DEPLOY_APPLICATION = 'pathfinder-proxy'

        PROJECT_PATHS = ['travel/rasp/pathfinder_proxy']
        WIKI_PAGE = 'raspisanija/releases/pathfinder_proxy/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз pathfinder-proxy {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
