# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class SuburbanWidgetCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Suburban Widget'
        NAME = 'rasp_suburban_widget'

        RESPONSIBLE = 'anded'

        PROJECT_PACKAGE_PATH = 'travel/rasp/suburban_widget/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_SUBURBAN_WIDGET_BINARY'

        DEPLOY_APPLICATION = 'suburban-widget'

        PROJECT_PATHS = ['travel/rasp/suburban_widget']
        WIKI_PAGE = 'raspisanija/releases/suburban_widget/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз suburban_widget {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
