# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy


class SuburbanWizardApiCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Suburban Wizard Api'
        NAME = 'rasp_suburban_wizard_api'

        RESPONSIBLE = 'lorekhov'
        FOLLOWERS = [
            'lorekhov',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/wizards/suburban_wizard_api/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_SUBURBAN_WIZARD_API_BINARY'

        DEPLOY_APPLICATION = 'suburban-wizard-api'

        PROJECT_PATHS = [
            'travel/rasp/wizards/suburban_wizard_api',
            'travel/rasp/wizards/wizard_lib',
        ]
        WIKI_PAGE = 'raspisanija/releases/wizards/suburban'
        ST_QUEUE = 'RASPWIZARDS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз suburban-wizard-api {}'
        ST_COMPONENTS = 'rasp-wizards-api-releases'
