# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class TouchCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Touch'
        NAME = 'rasp_touch'

        PROJECT_PACKAGE_PATH = 'travel/rasp/touch/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_TOUCH_BINARY'

        DEPLOY_APPLICATION = 'touch'

        PROJECT_PATHS = ['travel/rasp/touch']
        WIKI_PAGE = 'raspisanija/releases/touch/'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз touch {}'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
