# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy


class TrainApiCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Train Api'
        NAME = 'rasp_train_api'

        RESPONSIBLE = 'lorekhov'
        FOLLOWERS = [
            'lorekhov',
            'shenfeld',
            'alekto',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/train_api/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_TRAIN_API_BINARY'

        DEPLOY_PROJECT = 'trains'
        DEPLOY_APPLICATION = 'train-api'

        OBSERVED_PATHS = ['travel/rasp/train_api']
        WIKI_PAGE = 'raspisanija/releases/train_api/'
        ST_QUEUE = 'TRAINS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз train-api {}'
        ST_COMPONENTS = 'train-api-releases'
