# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy
import sandbox.projects.release_machine.core.const as rm_const


class TrainOfferStorageCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Train offer storage'
        NAME = 'train_offer_storage'

        RESPONSIBLE = 'ganintsev'
        FOLLOWERS = [
            'ganintsev',
            'alekto',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/train_offer_storage/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_TRAIN_OFFER_STORAGE_BINARY'

        DEPLOY_PROJECT = 'trains'
        DEPLOY_APPLICATION = 'offer-storage'

        OBSERVED_PATHS = ['travel/rasp/train_offer_storage']
        WIKI_PAGE = 'raspisanija/releases/train_offer_storage/'
        ST_QUEUE = 'TRAINS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз train-offer-storage {}'
        ST_COMPONENTS = 'train-offer-storage-releases'

        RELEASE_BUTTON_DEPLOY_STAGES = [
            rm_const.ReleaseStatus.stable,
        ]
