# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base as base


class TrainWizardApiCfg(base.RaspCfg, base.FinalConfig):
    class CfgParams(base.RaspCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Train Wizard Api'
        NAME = 'rasp_train_wizard_api'

        RESPONSIBLE = 'lorekhov'
        FOLLOWERS = [
            'lorekhov',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/wizards/train_wizard_api/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_TRAIN_WIZARD_API_BINARY'

        QLOUD_APPLICATION = 'train-wizard-api'

        PROJECT_PATHS = [
            'travel/rasp/wizards/train_wizard_api',
            'travel/rasp/wizards/wizard_lib',
        ]
        WIKI_PAGE = 'raspisanija/releases/wizards/train'
        ST_QUEUE = 'RASPWIZARDS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз train-wizard-api {}'
        ST_COMPONENTS = 'rasp-wizards-api-releases'
