# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

# alias for base class module is obligatory because of testenv specifics
import sandbox.projects.release_machine.components.configs.rasp._base_deploy as base_deploy


class WizardProxyApiCfg(base_deploy.RaspDeployCfg, base_deploy.FinalConfig):
    class CfgParams(base_deploy.RaspDeployCfg.CfgParams):
        DISPLAY_NAME = 'Rasp Wizard Proxy Api'
        NAME = 'rasp_wizard_proxy_api'

        RESPONSIBLE = 'lorekhov'
        FOLLOWERS = [
            'lorekhov',
        ]

        PROJECT_PACKAGE_PATH = 'travel/rasp/wizards/proxy_api/pkg.json'
        APPLICATION_RESOURCE_NAME = 'RASP_WIZARD_PROXY_API_BINARY'

        DEPLOY_APPLICATION = 'wizard-proxy-api'

        PROJECT_PATHS = [
            'travel/rasp/wizards/proxy_api',
            'travel/rasp/wizards/wizard_lib',
        ]
        WIKI_PAGE = 'raspisanija/releases/wizards/proxy'
        ST_QUEUE = 'RASPWIZARDS'
        ST_RELEASE_SUMMARY_TEMPLATE = 'Релиз wizard-proxy-api {}'
        ST_COMPONENTS = 'rasp-wizards-api-releases'
