# -*- coding: utf-8 -*-

import itertools
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows


class RearrangeDynamicCfg(configs.ReferenceTaggedConfig):
    name = "rearrange_dynamic"
    responsible = "elshiko"
    max_running_task_capacity = 2

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_db = "rearrange-dynamic"
        trunk_task_owner = "SEARCH-RELEASERS"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                default_tag_part = super(self.__class__, self)._tag_part

                class ChartParamsBuild(jg_utils.ChartParams):
                    ChartLines = ("directory_size", "bundle_size")
                    ChartYAxes = "MiB"
                    UsePointComments = False

                class ChartParamsRearr(jg_utils.ChartParams):
                    ChartLines = ("testing_time",)
                    ChartYAxes = "Hours"
                    UsePointComments = False

                _RD_TESTS_PATHS = [
                    "search/web/rearrs_upper/tests",
                    "search/web/rearrs_upper/rearrange.dynamic",
                ]
                CURRENT_PERSON_ON_DUTY = "elshiko"
                RD_METRICS_SLA_PROJECT = "aa8286386850f0df016874cc48882d44"

                def get_data_from_task(params):
                    timing = params.ctx.get("children_execution_timing")
                    testing_time = None
                    if (
                        isinstance(timing, list) and len(timing) >= 2 and
                        isinstance(timing[0], float) and
                        isinstance(timing[-1], float)
                    ):
                        testing_time = (timing[-1] - timing[0]) / 3600.0
                    return {
                        "testing_time": testing_time,
                    }

                tag_part = [
                    jg_release.JobGraphElementNewTagTagged(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogTagged(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        task_name="BUILD_REARRANGE_DYNAMIC",
                        job_params={
                            "observed_paths": ["search/web/rearrs_upper/rearrange.dynamic"],
                            "get_data_from_task": lambda params: {
                                "directory_size": (
                                    int(params.ctx["directory_size"]) if "directory_size" in params.ctx else None
                                ),
                                "bundle_size": int(params.ctx["bundle_size"]) if "bundle_size" in params.ctx else None,
                            },
                            "chart": ChartParamsBuild(),
                        },
                        out={
                            "REARRANGE_DYNAMIC_DATA": 40,
                            # "REARRANGE_DYNAMIC_BUNDLE": 40,
                        },
                        ctx={
                            "use_archiver": True,
                        },
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="YA_MAKE",
                        job_params={
                            "job_name_parameter": "LAUNCH_ARCTESTS",
                            "observed_paths": ["search/web/rearrs_upper/rearrange.dynamic"],
                            "apiargs": {
                                "requirements": {
                                    "ram": 24 * 1024 ** 3,  # 24 Gb
                                    "disk_space": 80 * (1024 ** 3),  # 80 Gb
                                },
                            },
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 5),
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                transform=lambda x, rm_config: "arcadia:/arc/trunk/arcadia@{}".format(x.revision),
                            ),
                        ),
                        ctx={
                            "targets": ";".join(_RD_TESTS_PATHS),
                            "clear_build": False,
                            "test": True,
                            "report_tests_only": True,
                            "disable_test_timeout": True,
                            "cache_test_results": False,
                            "tests_retries": 2,
                        },
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorTagged(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="release_number",
                                        output_key="new_tag_number",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="rearrange_dynamic",
                                        resource_name="REARRANGE_DYNAMIC_DATA",
                                    ),
                                ),
                            ),
                        ),
                        ctx={"beta_name_source": "STRING", "patch_name": "testing"},
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="CHECK_UPPER_EXP",
                        job_params={
                            "job_name_parameter": "CHECK_NOAPACHEUPPER_EXPERIMENT",
                            "observed_paths": ["search/web/rearrs_upper/rearrange.dynamic"],
                            "apiargs": {
                                "notifications": [{
                                    "transport": jg_utils.TaskNotifications.Transport.EMAIL,
                                    "statuses": [jg_utils.TaskStatus.SUCCESS, jg_utils.TaskStatus.FAILURE],
                                    "recipients": [CURRENT_PERSON_ON_DUTY],
                                }],
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="rearrange_dynamic_data",
                                        resource_name="REARRANGE_DYNAMIC_DATA",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "scraper_pool": "rearrange-dynamic_web_priemka",
                        },
                    ),
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "out": {"TASK_LOGS": 25},
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="rearrange_dynamic",
                                        resource_name="REARRANGE_DYNAMIC_DATA",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="WEB_MOCKED_SOURCES",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="launch_metrics_id",
                                    ),
                                ),
                            ),
                            jg_arrows.ParentsData(
                                input_key="tasks_to_check",
                                triggers=(
                                    jg_job_triggers.JobTriggerBuild(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="build_id",
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="LAUNCH_ARCTESTS",
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="arctests_id",
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="CHECK_NOAPACHEUPPER_EXPERIMENT",
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="exp_id",
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="BLENDER_PERFORMANCE_VS_PROD_V2",
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="blender_id",
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerWiki(
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="wiki_id",
                                            ),
                                        ),
                                    ),
                                ),
                                # WARNING! Legacy code. It is not safe to add anything here.
                                # Ask mvel@ or ilyaturuntaev@ first
                                transform=lambda build_id, arctests_id, exp_id, blender_id, wiki_id: ",".join(
                                    map(str, [
                                        build_id,
                                        arctests_id,
                                        exp_id,
                                        blender_id,
                                        wiki_id,
                                    ])
                                ),
                            )
                        ),
                    ),
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.DEFINED_BY_CODE, None),
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(4, 6), (12, 14), (20, 22)],
                                seconds_from_last_run_start_time=4 * 3600,
                                ignored_jobs=[
                                    rm_const.JobTypes.rm_job_name(rm_const.JobTypes.TEST, self.name, "LAUNCH_ARCTESTS")
                                ],
                            ),
                        },
                    ),
                ]
                for job_name_param, vertical, add_cgi, checked_beta, frequency, custom_schedule, observed_paths in [
                    (
                        "WEB_MOCKED_SOURCES",
                        "web",
                        "",
                        "rd-testing.hamster",
                        (jg_utils.TestFrequency.LAZY, None),
                        None,
                        ["search/web/rearrs_upper/rearrange.dynamic"],
                    ),
                    (
                        "WEB_FILL_CACHE_FOR_MOCKED_SOURCES",
                        "web",
                        "&init_meta=blender_request_cache_put",
                        "upper-hamster.hamster",
                        (jg_utils.TestFrequency.DEFINED_BY_CODE, None),
                        jg_utils.CustomSchedule(
                            time_interval_list=[(22, 24), (5, 7)],
                            seconds_from_last_run_start_time=8 * 3600,
                            last_run_finished=True,
                        ),
                        None,
                    ),
                ]:
                    triggers_required = job_name_param != "WEB_FILL_CACHE_FOR_MOCKED_SOURCES"
                    tag_part.append(
                        jg_test.JobGraphElementLaunchMetrics(
                            search_subtype=vertical,
                            job_name_parameter=job_name_param,
                            job_params={
                                "observed_paths": observed_paths,
                                "apiargs": {
                                    "notifications": [{
                                        "transport": jg_utils.TaskNotifications.Transport.EMAIL,
                                        "statuses": [jg_utils.TaskStatus.SUCCESS, jg_utils.TaskStatus.FAILURE],
                                        "recipients": [CURRENT_PERSON_ON_DUTY],
                                    }],
                                },
                                "chart": ChartParamsRearr(),
                                "get_data_from_task": get_data_from_task,
                                "get_data_from_task_on_fail": get_data_from_task,
                                "frequency": frequency,
                                "next_revision_custom_schedule": custom_schedule,
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="release_number",
                                            output_key="new_tag_number",
                                        ),
                                    ),
                                ) if triggers_required else None,
                                (
                                    jg_job_triggers.JobTriggerBuild()
                                    if triggers_required else None
                                ),
                                jg_job_triggers.JobTriggerGenerateBeta(
                                    job_name_parameter="beta",
                                ) if triggers_required else None,
                            ),
                            ctx={
                                "custom_template_name": "experiments.json",
                                "beta_conf_type": "",
                                "scraper_over_yt_pool": "upper_{}_priemka".format(vertical),
                                "sla_project": RD_METRICS_SLA_PROJECT,
                                "sample_beta": "upper-hamster.hamster",
                                "sample_extra_params": "&graphrwr=:web:mocked_sources_web&noredirect=1{}".format(add_cgi),
                                "checked_beta": checked_beta,
                                "checked_extra_params": "&graphrwr=:web:mocked_sources_web&noredirect=1",
                            },
                            release_number_default=(not triggers_required)
                        )
                    )
                for blender_perf_version, nruns, frequency in [
                    ("", 4, (jg_utils.TestFrequency.LAZY, None)),
                    ("_V2", 6, (jg_utils.TestFrequency.LAZY, None)),
                ]:
                    tag_part.append(
                        jg_test.JobGraphElementTestTagCommon(
                            task_name="COMPARE_MIDDLESEARCH_BINARIES",
                            job_params={
                                "job_name_parameter": "BLENDER_PERFORMANCE_VS_PROD{}".format(blender_perf_version),
                                "restart_policy": (
                                    {
                                        "sleep_before_action": 0,  # min
                                        "default_action": rm_const.RestartPolicyActions.NOOP,
                                        "override_default_action": {
                                            "EXCEPTION": rm_const.RestartPolicyActions.RECREATE,
                                            "FAILURE": rm_const.RestartPolicyActions.RECREATE,
                                        },
                                    },
                                ),
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataResource(
                                            input_key="rearrange_dynamic_data_2_resource_id",
                                            resource_name="REARRANGE_DYNAMIC_DATA",
                                        ),
                                    ),
                                ),
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="release_number",
                                            output_key="new_tag_number",
                                        ),
                                    ),
                                ),
                                jg_arrows.GlobalResourceData(
                                    input_key="noapache_1_requests_resource_id",
                                    resource_name="BLENDER_GRPC_CLIENT_PLAN",
                                ),
                                jg_arrows.GlobalResourceData(
                                    input_key="noapache_2_requests_resource_id",
                                    resource_name="BLENDER_GRPC_CLIENT_PLAN",
                                ),
                            ),
                            ctx={
                                "launch_mode": "upper",
                                "req_count": 15000,
                                "calc_mode": "blender",
                                "auto_mode": "nocache",
                                "enable_auto_diffs": False,
                                "fail_on_slowdown_threshold_q95": 500,
                                "fail_on_rearrange_slowdown_threshold_q95": 500,
                                "nruns": nruns,
                                "noapacheupper_1_max_calc_relev_queue_size": 0,
                                "noapacheupper_2_max_calc_relev_queue_size": 0,
                                "use_new_calc_eventlog_stats": True if blender_perf_version == "_V2" else False,
                            }
                        ),
                    )
                return default_tag_part + tag_part

    class Releases(configs.ReferenceTaggedConfig.Releases):
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            services = [
                (
                    "web",
                    (
                        [
                            ri.DeployService("production_noapache_{}_web_yp".format(i), ["prod", "web"])
                            for i in rm_const.MAIN_LOCATIONS
                        ] + [
                            ri.DeployService("hamster_noapache_{}_web_yp".format(i), ["hamster", "web"])
                            for i in rm_const.MAIN_LOCATIONS
                        ] + [
                            ri.DeployService("prestable_noapache_sas_web_yp", ["prestable", "web"])
                        ]
                    ),
                ),
                (
                    "imgs",
                    (
                        [
                            ri.DeployService("production_noapache_{}_imgs_rkub".format(i), ["prod", "imgs"])
                            for i in rm_const.MAIN_LOCATIONS
                        ] + [
                            ri.DeployService("hamster_noapache_{}_imgs".format(i), ["hamster", "imgs"])
                            for i in rm_const.MAIN_LOCATIONS
                        ]
                    )
                ),
                (
                    "video",
                    (
                        [
                            ri.DeployService("production_noapache_{}_video_rkub".format(i), ["prod", "video"])
                            for i in ["sas", "vla"]
                        ] + [
                            ri.DeployService("production_noapache_{}_video_yp".format(i), ["prod", "video"])
                            for i in rm_const.MAIN_LOCATIONS
                        ] + [
                            ri.DeployService("hamster_noapache_{}_video_yp".format(i), ["hamster", "video"])
                            for i in rm_const.MAIN_LOCATIONS
                        ]
                    )
                )
            ]

            deploy_infos = [
                ri.NannyDeployInfo(
                    services=list(itertools.chain.from_iterable(i[1] for i in services))
                )
            ]

            return [
                ri.ReleasableItem(
                    name="rearrange_dynamic",
                    data=ri.SandboxResourceData("REARRANGE_DYNAMIC_DATA"),
                    deploy_infos=deploy_infos
                )
            ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="rd",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="rd",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="rearrange.dynamic", param_name="rearrange_dynamic"
                            )
                        ],
                        parent_service="hamster_noapache_vla_web_yp",
                        ignore_instance_spec=True,
                    ),
                ],
            ),
        }

    class SvnCfg(configs.ReferenceTaggedConfig.SvnCfg):
        tag_name = "rearrange.dynamic"

    class Notify(configs.ReferenceTaggedConfig.Notify):

        use_startrek = True

        class Startrek(configs.ReferenceTaggedConfig.Notify.Startrek):
            assignee = configs.Responsible(abc=configs.Abc(component_id=1609), login="elshiko")
            queue = "UPREL"
            dev_queue = "SEARCH"
            followers = []
            summary_template = u"Приемка rearrange.dynamic {}"
            use_task_author_as_assignee = False
            deadline = 7
            ticket_description_prefix = "Приемочная бета: http://rd-testing.hamster.yandex.ru/yandsearch?text=teddy"

    class ChangelogCfg(configs.ReferenceTaggedConfig.ChangelogCfg):
        wiki_page = "poiskovajaplatforma/rearrange.dynamic/sequence/"
        dirs = ["arcadia/search/web/rearrs_upper/rearrange.dynamic"]

    def __init__(self):
        super(RearrangeDynamicCfg, self).__init__()
        self.yappy_cfg = self.Yappy()
        self.notify_cfg = self.Notify(self.name)
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
