# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow


class RecommenderManagerCfg(configs.ReferenceCIConfig):
    name = "recommender_manager"
    display_name = "Itditp Recommender Manager"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="searchrecommender"),
        login="bogdanovilya",
    )

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        build_task = "KOSHER_YA_MAKE"

        @jg_flow.release_flow()
        def release(self):
            graph = super(self.__class__, self).release(self)

            release_testing = graph.get("release_testing_nanny")
            release_testing.manual = False
            release_testing.input.update(wait_for_deploy=True)
            new_tag = graph.get("new_tag")

            load_requests = jg_cube.Cube(
                name="load_requests",
                task="projects/recommender_manager/load_requests",
                needs=[new_tag],
            )

            update_resources = jg_cube.Cube(
                name="update_resources",
                task="projects/recommender_manager/update_resources_for_beta_component",
                needs=[new_tag],
            )

            shooter = jg_cube.Cube(
                name="shoot",
                task="projects/recommender_manager/shoot_recommender_manager",
                needs=[
                    release_testing,
                    update_resources,
                ],
                input=jg_cube.CubeInput(
                    requests=load_requests.output.resources["PLAIN_TEXT_QUERIES"][0].id,
                    dolbilka_executor_time_limit=60,
                    dolbilka_executor_max_simultaneous_requests=1,
                    dolbilka_executor_mode="plan",
                    dolbilka_executor_requests_limit=100,
                    dolbilka_request_timeout=10000,
                    dolbilka_fixed_rps=5,
                ),
            )

            summarize_shooting = jg_cube.Cube(
                name="summarize_shooting",
                task="projects/recommender_manager/summarize_shooting_recommender_manager",
                needs=[
                    shooter
                ],
                input=jg_cube.CubeInput(
                    responses=shooter.output.resources["RESPONSES_FOR_RECOMMENDER_MANAGER"][0].id,
                ),
            )

            release_stable = graph.get("release_stable_nanny")
            release_stable.add_requirement(summarize_shooting)

            graph.add(load_requests)
            graph.add(update_resources)
            graph.add(shooter)
            graph.add(summarize_shooting)

            return graph

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/trailer/recommender/manager"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"
        ya_make_abs_paths_glob = [
            "quality/trailer/recommender/manager/**"
        ]
        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="recommender_manager",
                    build_data=ri.BuildData(
                        target="quality/trailer/recommender/manager/recommender_manager",
                        artifact="quality/trailer/recommender/manager/recommender_manager",
                    ),
                    data=ri.SandboxResourceData("RECOMMENDER_MANAGER_EXECUTABLE", ttl=180),
                    deploy_infos=[
                        ri.single_nanny_service("recommender_manager"),
                        ri.single_nanny_service("recommender_manager_r1", stage=rm_const.ReleaseStatus.testing),
                    ],
                ),
            ]
        release_followers_permanent = [
            "bogdanovilya",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = ["middle_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = "https://t.me/joinchat/A5uMiUHgeA0Nvbqhj4eEZw"

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "bogdanovilya"
            queue = "ITDITPRELEASE"
            dev_queue = "SEARCH"
            summary_template = "Recommender manager acceptance {}"
            workflow = {}
            followers = [
                "boganovilya"
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/recommendermanager/releases/"
        ya_make_targets = [
            "quality/trailer/recommender/manager",
        ]
